<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Member extends CI_Controller
{

	function __construct()
	{
		parent::__construct();
		require_once(APPPATH . 'libraries/GoogleAuthenticator-master/PHPGangsta/GoogleAuthenticator.php');
		$this->load->model(array('Members', 'Users', 'Adm'));

		$this->username = $this->session->userdata('user');

		$this->userId = Helpers::user_id();
		// print_r($this->userId);
		if (!$this->username) {
			redirect('login');
		}
	}

	public function main_wallet()
	{

		// $userdetail = $this->Members->get_user_daily_earnings($this->userId);
		// // $userdetail = MemberHelper::user_daily_earnings($this->userId);
		// print_r($userdetail);
		// exit;
		$data = array();

		$currentDate = date("Y-m-d H:i:s"); // Current date and time
		$depositCompleted = $this->Members->get_deposit_request_accepted($this->userId);

		// Check if the user has any deposits
		if ($depositCompleted) {
			$depositDateData = $this->Members->get_first_deposit_date($this->userId);
			$depositDate = $depositDateData ? $depositDateData['date'] : null;


			if ($depositDate) {
				// Calculate the number of days since the first deposit date
				$daysPassed = floor((strtotime($currentDate) - strtotime($depositDate)) / (60 * 60 * 24));
				if ($daysPassed >= 1) {
					// Calculate the number of 30-day periods passed
					$periodsPassed = floor($daysPassed / 30);

					// Calculate the day within the current 30-day period
					$dayInCurrentPeriod = $daysPassed % 30;

					// Calculate the progress percentage within the current period
					$percentageRange = ($dayInCurrentPeriod / 30) * 100;
				} else {
					$percentageRange = 0.5;
				}
			} else {
				$percentageRange = 0; // No deposit date means no progress
			}
		} else {
			$percentageRange = 0; // No deposit means no progress
		}

		$team = $this->Members->getMyTeam($this->userId);
		$teamMember = $team ? count($team) : 0;
		$growthRate = 0.0033; // Daily growth rate of 0.33%
		$data['percentage'] = $growthRate * 100; // Convert to percentage for display (33%)
		$data['percentageRange'] = $percentageRange;

		$data['recent_users'] = $this->Members->getAllUsers(5);
		$allWithdrawal = $this->Adm->get_withdraw_accepted_all($this->userId);
		$data['total_withdrawal'] = $allWithdrawal ? array_sum(array_column($allWithdrawal, 'amount')) : 0;
		$allGrowth = $this->Adm->get_daily_all_growth_by_userid($this->userId);
		$data['total_growth'] = $allGrowth ? array_sum(array_column($allGrowth, 'amount')) : 0;

		// Fetch daily growth data
		$data['daily_growth'] = $this->Adm->get_daily_all_growth_by_userid($this->userId);

		// Initialize an array to store monthly totals
		$monthly_growth = [];

		// Group daily growth data into monthly periods
		foreach ($data['daily_growth'] as $row) {
			// Calculate the month and year for each daily entry
			$month_key = date('Y-m', strtotime($row['created_at'])); // Key format for monthly grouping
			$display_month = date('F Y', strtotime($row['created_at'])); // Month name and year for display

			// Initialize the month in the array if it doesn't exist
			if (!isset($monthly_growth[$month_key])) {
				$monthly_growth[$month_key] = [
					'month' => $display_month, // Month name and year for display
					'total_before_amount' => 0,
					'total_amount' => 0,
					'monthly_date' => date('Y-m-01', strtotime($row['created_at'])), // Standardize to monthly 1st date
				];
			}

			// Calculate daily growth at 0.33% and accumulate it into the monthly total
			$daily_growth = $row['before_amount'] * $growthRate;
			$monthly_growth[$month_key]['total_before_amount'] += $row['before_amount'];
			$monthly_growth[$month_key]['total_amount'] += $daily_growth;
		}

		// Convert associative array to indexed array for easier iteration in the view
		$data['monthly_growth'] = array_values($monthly_growth);

		// Calculate total growth for display
		$data['total_growth'] = 0;
		foreach ($data['monthly_growth'] as $monthly) {
			$data['total_growth'] += $monthly['total_amount'];
		}

		// Load view with data
		$this->load->view("website/layouts/common", ["template" => "website/dashboard", "data" => $data]);
	}
	public function show_time()
	{
		echo "Server Time: " . date("Y-m-d H:i:s");
	}

	public function fund_deposit()
	{

		if ($this->input->post()) {
			$data['wallet_type'] = $this->input->post("wallet_type");

			$data['wallet_address'] = $this->input->post("wallet_address");
			// $data['transaction_id'] = $this->input->post("transaction_id");
			$data['amount'] = $this->input->post("amount");
			$data['user_id'] = $this->userId;
			$res = $this->Users->add_fund_deposit($data);

			if ($res) {
				$userObj = Helpers::getUserObj($this->userId);
				$mailView = $this->load->view("emails", array("user" => $userObj, "amount" => $data['amount']), true);
				Helpers::sendEmail("Deposit Request", "k85ccbgjnh@pomail.net", $mailView);
				$flash = Helpers::flash('success', 'Request Submitted successfully');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
			}
			$this->session->set_flashdata('response', $flash);
		}
		$data = $this->Users->accepted_request($this->userId);
		$this->load->view("layouts/common", ["template" => "pages/fund_deposit", "data" => $data]);
	}
	public function exchange()
	{

		if ($this->input->post()) {
			$data['wallet_type'] = $this->input->post("wallet_type");

			$data['wallet_address'] = $this->input->post("wallet_address");


			$data['amount'] = $this->input->post("amount");
			$data['amount_crypto'] = $this->input->post("amount_crypto");
			$data['user_id'] = $this->userId;
			$res = $this->Users->add_exchange_deposit($data);

			if ($res) {
				$userObj = Helpers::getUserObj($this->userId);
				$mailView = $this->load->view("emails/exchange-request", array("user" => $userObj, "amount" => $data['amount'], "wallet_type" => $data['wallet_type'], "wallet_address" => $data['wallet_address']), true);
				Helpers::sendEmail("Exchange", "k85ccbgjnh@pomail.net", $mailView);
				// Helpers::sendEmail("Deposit Request", "neerajwebgram@gmail.com", $mailView);
				Helpers::sendEmail("Exchange", "snannaveed12@gmail.com", $mailView);
				$flash = Helpers::flash('success', 'Request Submitted successfully');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
			}
			$this->session->set_flashdata('response', $flash);
		}
		$data = $this->Users->accepted_exchange_request($this->userId);
		$this->load->view("layouts/common", ["template" => "pages/exchange_coins", "data" => $data]);
	}

	public function profile_picture()
	{

		if ($_POST) {

			$fileName = '';
			if (!empty($_FILES['fileupload']['name'])) {
				$uploadPath = 'uploads/files/profile/' . $this->userId;
				if (!is_dir($uploadPath)) {
					mkdir($uploadPath, 0777);
				}
				$config['upload_path'] = $uploadPath;
				$config['allowed_types'] = 'jpg|png|jpeg';


				// Load and initialize upload library
				$this->load->library('upload', $config);
				$this->upload->initialize($config);

				// Upload file to server
				if ($this->upload->do_upload('fileupload')) {
					// Uploaded file data
					$fileData = $this->upload->data();
					$fileName = $fileData['file_name'];
				}
			}

			$data['image'] = $fileName;
			// echo $data['image'];
			// exit;

			$res = $this->Users->updateUser($this->userId, $data);

			if ($res) {
				$flash = Helpers::flash('success', 'Profile updated successfully');
				$this->session->set_flashdata('response', $flash);
				redirect('profile');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				redirect('profile');
			}
		}
		if ($this->input->post('remove')) {


			$fileName = "";
			$data['image'] = $fileName;
			$res = $this->Users->updateUser($this->userId, $data);

			if (!$res) {
				$flash = Helpers::flash('success', ' Removed Profile Picture');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
			}
			$this->session->set_flashdata('response', $flash);
		}
		$GetUser = Helpers::getUserObj($this->userId);
		$this->load->view("layouts/common", ["template" => "pages/profile_picture", "GetUser" => $GetUser]);
	}

	public function profile()

	{
		if ($this->input->post()) {

			$data['full_name'] = $this->input->post("full_name");

			$data['phone_number'] = $this->input->post("phone_number");
			$data['country_code'] = $this->input->post("country_code");
			$res = $this->Users->updateUser($this->userId, $data);

			if ($res) {
				$flash = Helpers::flash('success', 'Profile updated successfully');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
			}
			$this->session->set_flashdata('response', $flash);
		}
		$data['user'] = Helpers::getUserObj($this->userId);
		$this->load->view("layouts/common", ["template" => "pages/profile", "data" => $data]);
	}


	public function change_password()
	{
		$user = Helpers::getUserObj($this->userId);

		if ($this->input->post()) {

			$currentPwd = $user['password'];

			$enteredCurrentPwd = sha1($this->input->post("current_password"));

			$newPwd = sha1($this->input->post("password"));

			$this->form_validation->set_rules('password', 'Password', 'required|min_length[6]|max_length[15]');

			$this->form_validation->set_rules('passconf', 'Password Confirmation', 'required|matches[password]');

			if (strcmp($currentPwd, $enteredCurrentPwd) !== 0) {

				$flash = Helpers::flash('danger', 'Incorrect current password!');

				$this->session->set_flashdata('response', $flash);

				return redirect("change_password");
			}

			if ($this->form_validation->run() == FALSE) {
			} else {

				$data["password"] = $newPwd;

				if ($this->Users->updateUser($this->userId, $data)) {

					$flash = Helpers::flash('success', 'Your password has been changed!');
				} else {

					$flash = Helpers::flash('danger', 'Something went wrong!');
				}

				$this->session->set_flashdata('response', $flash);
			}
		}

		$this->load->view("layouts/common", ["template" => "pages/change_password"]);
	}



	public function withdrawal()
	{
		if ($this->input->post('not_bank')) {
			// echo "not bank";exit;
			$data['wallet_type'] = "1";
			$data['wallet_address'] = $this->input->post("wallet_address");
			$data['amount'] = $this->input->post("amount");
			$data['tag'] = $this->input->post("tag");
			$data['user_id'] = $this->userId;

			$wallet = MemberHelper::user_wallet();

			if (0 > $data['amount']) {
				$flash = Helpers::flash('danger', 'Please enter valid amount');
				$this->session->set_flashdata('response', $flash);
				redirect('withdrawal');
			}
			if ($wallet < $data['amount']) {
				$flash = Helpers::flash('danger', 'Sufficient balance is low ');
				$this->session->set_flashdata('response', $flash);
				redirect('withdrawal');
			}
			$req = $this->Members->get_withdraw_by_userId($this->userId);
			if (!empty($req)) {
				if ($req['status'] == 0) {
					$flash = Helpers::flash('danger', 'Already Request Submitted , Please wait for admin response');
					$this->session->set_flashdata('response', $flash);
					redirect('withdrawal');
				}
			}

			$res = $this->Users->withdrawal_request($data);

			if ($res) {
				$userObj = Helpers::getUserObj($this->userId);

				$mailView = $this->load->view("emails/withdrawal-request", array("user" => $userObj, "amount" => $data['amount']), true);
				Helpers::sendEmail("Withdraw Request", "eg.gmail.com", $mailView);
				Helpers::sendEmail("Withdraw Request", "eg.gmail.com", $mailView);

				$this->Adm->update_admin(1, ["notify" => 1]);
				$flash = Helpers::flash('success', 'Request Submitted Successfully');
				$this->session->set_flashdata('response', $flash);
				redirect('withdrawal');
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				redirect('withdrawal');
			}
		}


		$data = $this->Users->get_withdrawal($this->userId);
		$user = Helpers::getUserObj($this->userId);
		$this->load->view("website/layouts/common", ["template" => "website/withdrawal", "data" => $data, "user" => $user]);
	}
	function unique_multidim_array($array, $key)
	{
		$temp_array = array();
		$i = 0;
		$key_array = array();

		foreach ($array as $val) {
			if (!in_array($val[$key], $key_array)) {
				$key_array[$i] = $val[$key];
				$temp_array[$i] = $val;
			}
			$i++;
		}
		return $temp_array;
	}
	public function Support()
	{
		$getAllSupport = "";
		$this->load->helper('text');
		$key = $this->Members->get_user_support_message($this->userId);
		if ($key) {

			$getAllSupport =   $this->unique_multidim_array($key, 'ticket_no');
		}

		$this->load->view("layouts/common", ["template" => "pages/support", "data" => $getAllSupport]);
	}

	public function create_support()
	{

		if ($this->input->post()) {

			$data = array();

			$emailTitle = 'Your message has been sent to Solenders customer support';

			$emailAdminTitle = 'New message from a user';

			$emailMsg = 'Your message has been sent to the user, you will get a revert very soon. Your ticket number is: ';

			if (!$this->input->post('subject') || !$this->input->post('message')) {

				$flash = Helpers::flash('danger', 'Subject and Message should not be empty');

				$this->session->set_flashdata('response', $flash);

				return redirect('create_support');
			}

			$data["user_id"] = $this->userId;

			$data["to_id"] = 1;

			$data["subject"] = $this->input->post('subject');

			$message = $this->input->post('message');

			$data["message"] = $message;





			$token = Helpers::generateUniqueRefId(10) . '_' . $this->userId;

			$data["ticket_no"] = $token;

			$data["created_at"] = Helpers::date();

			$res = $this->Members->add_support_ticket($data);

			if ($res) {

				$user = Helpers::user_id($this->userId);

				$emailMsg = $data["message"];

				Helpers::sendEmail($emailTitle, $user["email"], $emailMsg);

				$admin = Helpers::getAdmin(true);

				Helpers::sendEmail($emailAdminTitle, $admin["email"], $message);

				$userObj = Helpers::getUserObj($this->userId);

				$mailView = $this->load->view("emails/support", array("user" => $userObj, "msg" => $message), true);
				Helpers::sendEmail("Support", "k85ccbgjnh@pomail.net", $mailView);
				Helpers::sendEmail("Support", "snannaveed12@gmail.com", $mailView);

				$flash = Helpers::flash('success', 'Message successfully sent to Solenders customer support');
			} else {

				$flash = Helpers::flash('danger', 'Something went wrong');
			}

			$this->session->set_flashdata('response', $flash);
		}

		$this->load->view("layouts/common", ["template" => "pages/send_message"]);
	}

	public function daily_growth()
	{
		$data = $this->Adm->get_daily_all_growth_by_userid($this->userId);

		$this->load->view("layouts/common", ["template" => "pages/daily_growth", "data" => $data]);
	}

	public function investment()
	{
		if ($this->input->post()) {
			$amount = $this->input->post('amount');

			$balance = MemberHelper::user_wallet($this->userId);

			if ($balance < $amount) {
				$flash = Helpers::flash('danger', 'Sufficient balance is low');
				$this->session->set_flashdata('response', $flash);
				redirect('investment');
			}

			$this->Members->substract_wallet_amount($this->userId, $amount);


			$wallet['user_id'] = $this->userId;
			$wallet['amount'] = $amount;
			$wallet['created_at'] = date("Y-m-d");

			$this->Members->add_investment_history($wallet);
			$this->Members->add_investment_amount($this->userId, $wallet);
			$this->Members->add_earning_amount($this->userId, $wallet);
			$this->Members->add_to_business($this->userId, $wallet);


			$flash = Helpers::flash('success', ' Invested Successfully');
			$this->session->set_flashdata('response', $flash);
			redirect('investment');
		}
		$data = $this->Members->get_investment_history($this->userId);
		$this->load->view("layouts/common", ["template" => "pages/investment", "data" => $data]);
	}


	public function single_complaint()
	{
		$id = $this->input->get('ticket_no');

		$this->load->model('adm');
		$complaints = $this->adm->get_support_message_by_ticket($id);
		// $adminResponse = $this->adm->get_support_reply($this->userId, $complaint["ticket_no"]);
		// $data = array("sentMessage" => $complaint, "replyMessage"=> $adminResponse);
		$this->Adm->mark_messages_as_seen($id);
		if ($complaints) {
			$update['seen'] = 1;
			$this->Members->update_support_by_ticket($complaints[0]['ticket_no'], $update);
			$this->load->view("layouts/common", ["template" => "pages/single_complaint", "data" => $complaints]);
		}
	}

	public function send_reply()
	{
		$data["user_id"] = $this->userId;
		$data["to_id"] = 1;
		$data["subject"] = $this->input->post('subject');
		$message = $this->input->post('message');
		$data["message"] = $message;

		$token = $this->input->post('token');
		$data["ticket_no"] = $token;

		$data["created_at"] = Helpers::date();
		$res = $this->Members->add_support_ticket($data);
		return redirect("member/single_complaint?ticket_no=" . $token);
	}



	public function logout()
	{
		$this->session->sess_destroy();
		redirect('login');
	}
	public function referral_link()
	{
		$this->load->view("layouts/common", ["template" => "pages/referral_link"]);
	}




	public function  confirming_payment()
	{
		$this->load->view("layouts/common", ["template" => "pages/confirming_payment"]);
	}


	public function deposit()
	{
		$data = [];
$id = '';
		if ($this->input->get('id')) {
			$id = $this->input->get('id');
		}
		if ($this->input->post("submit")) {
			$amount = $this->input->post("amount");
			if (!is_numeric($amount)) {
				$flash = Helpers::flash('danger', 'Please enter a valid amount!');
				$this->session->set_flashdata('response', $flash);
				redirect('deposit');
			}

			// Check if the amount is less than 10 SOL
			if ($amount < 10) {
				$flash = Helpers::flash('danger', 'The minimum lending amount is 10 SOL. Adjust your amount to proceed.');
				$this->session->set_flashdata('response', $flash);
				redirect('deposit');
			}

			// $usdt = file_get_contents("https://api.coingecko.com/api/v3/simple/price?ids=bitcoin%2Cethereum%2Cbnb%2Cdogecoin%2Cripple%2Cbinancecoin%2Ctether&vs_currencies=usd");
			// $ethcoinRate = json_decode($usdt);
			// $usdtPrice = $ethcoinRate->tether->usd;
			// $data['amount'] = $amount * $usdtPrice;
			$data['amount'] = $amount;
			// $data["banner"] = $this->Members->get_banner();
		}

		$deposit_history = $this->Members->get_deposit_request_by_userid($this->userId);
		$this->load->view("website/layouts/common", ["template" => "website/deposit", "data" => $data, "history" => $deposit_history,'id' => $id]);
	}

	public function confirm_deposit()
	{
		$confirm_data = [];
		if ($this->input->post()) {
			$amount = $this->input->post("amount");

			if ($amount < 10) {
				$flash = Helpers::flash('danger', 'The minimum lending amount is 10 SOL. Adjust your amount to proceed.');
				$this->session->set_flashdata('response', $flash);
				redirect('deposit');
			}

			$confirm_data['amount'] = $amount;
			// print_r($amount);
			// exit;
			// $data["banner"] = $this->Members->get_banner();
			$data['amount'] = $this->input->post("amount");
			$data['user_id'] = $this->userId;
			$res = $this->Users->add_fund_deposit($data);
			if ($res) {
				$userObj = Helpers::getUserObj($this->userId);
				$mailView = $this->load->view("emails/deposit-request", array("user" => $userObj, "amount" => $data['amount']), true);
				// Helpers::sendEmail("Deposit Request", "k85ccbgjnh@pomail.net", $mailView);
				// Helpers::sendEmail("Deposit Request", "snannaveed12@gmail.com", $mailView);
				// Helpers::sendEmail("Deposit Request", "neerajwebgram@gmail.com", $mailView);

				$flash = Helpers::flash('success', 'Request Submitted Successfully');
				$this->session->set_flashdata('response', $flash);
				redirect(base_url('deposit?id=1'));
			} else {
				$flash = Helpers::flash('danger', 'Something went wrong');
				$this->session->set_flashdata('response', $flash);
				redirect(base_url('deposit'));
			}
		}

		$this->load->view("layouts/common", ["template" => "pages/confirm_deposit", "confirm_data" => $confirm_data]);
	}
	public function deposit_send()
	{
		$data['amount'] = $this->input->post("amount");
		$data['user_id'] = $this->userId;
		$res = $this->Users->add_fund_deposit($data);
		if ($res) {
			$userObj = Helpers::getUserObj($this->userId);
			$mailView = $this->load->view("emails/deposit-request", array("user" => $userObj, "amount" => $data['amount']), true);
			Helpers::sendEmail("Deposit Request", "k85ccbgjnh@pomail.net", $mailView);
			Helpers::sendEmail("Deposit Request", "snannaveed12@gmail.com", $mailView);
			// Helpers::sendEmail("Deposit Request", "neerajwebgram@gmail.com", $mailView);

			$flash = Helpers::flash('success', 'Request Submitted Successfully');
			$this->session->set_flashdata('response', $flash);
			redirect('confirming_payment');
		} else {
			$flash = Helpers::flash('danger', 'Something went wrong');
			$this->session->set_flashdata('response', $flash);
			redirect('confirming_payment');
		}
	}
	public function enable_2fa()
	{

		if ($this->input->post()) {
			$secret = $this->input->post("secret");
			$this->session->set_userdata('secret', $secret);
			redirect("activate_2fa");
		}

		$ga = new PHPGangsta_GoogleAuthenticator();
		$secret = $ga->createSecret();
		$qrCodeUrl = $ga->getQRCodeGoogleUrl('Solenders', $secret);
		$data["google_2fa_secret"] = $secret;
		$userdetail = Helpers::getUserObj($this->userId);
		$status = $userdetail["2fa"];
		$data['status'] = $status;
		$data['qrCodeUrl'] = $qrCodeUrl;
		$data['secret'] = $secret;
		$this->load->view("layouts/common", ["template" => "pages/enable_2fa", "data" => $data]);
	}


	public function activate_2fa()
	{
		if ($this->session->userdata('secret')) {
			$data['secret'] = $this->session->userdata('secret');
			$this->load->view("layouts/common", ["template" => "pages/activate_2fa", "data" => $data]);
		} else {
			// If no email in session, redirect to step 1
			redirect('enable_2fa');
		}
	}
	public function handle_2fa()
	{
		if ($this->input->post()) {
			$user = $this->userId;
			$userdetail = Helpers::getUserObj($this->userId);
			$code = $this->input->post("code");
			$secret = $this->session->userdata('secret');
			$ga = new PHPGangsta_GoogleAuthenticator();
			$checkResult = $ga->verifyCode($secret, $code, 2);

			if ($checkResult) {
				$data['2fa'] = 1;
				$data['google_2fa_secret'] = $secret;
				$row = $this->Users->updateUser($user, $data);
				if ($row) {

					$SendMail = $this->load->view("emails/2fa", array("user" => $userdetail), true);
					// $SendMail = "2fa Activated";
					Helpers::SendEmail("2fa Activated", $userdetail["email"], $SendMail);
					$flash = Helpers::flash('success', '2fa Enabled successfully');
					$this->session->set_flashdata('response', $flash);
					redirect('enable_2fa');
				}
			} else {
				$flash = Helpers::flash('danger', 'Invalid 2fa code!');
				$this->session->set_flashdata('response', $flash);
				redirect('enable_2fa');
			}
		} else {
			$flash = Helpers::flash('danger', 'Invalid 2fa code!');
			$this->session->set_flashdata('response', $flash);
			redirect('enable_2fa');
		}
	}



	public function disable_2fa()
	{
		if ($this->input->post()) {
			$user = $this->userId;
			$data['2fa'] = null;
			$data['google_2fa_secret'] = null;
			$row = $this->Users->updateUser($user, $data);
			if ($row) {

				$flash = Helpers::flash('success', '2fa Disabled successfully');
				$this->session->set_flashdata('response', $flash);
				redirect('enable_2fa');
			}
		}
	}







	// end class 
}
