<?php

class Adm extends ci_model
{
	public function update_settings($data)
	{
		$query = $this->db->update("settings", array("mp" => $data ));
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			return false;
		}
	}
	// public function update_xtc()
	// {
	// 	$query = $this->db->update("users", array("auto_withdraw" => $data ));
	// 	if($this->db->affected_rows()) {
	// 		return true;
	// 	}
	// 	else {
	// 		return false;
	// 	}
	// }
	public function single_user($id) {
		$data = $this->db->get_where('users',  array('id' =>$id))->row_array();
		return $data ? $data: false;
	}
	public function get_all_users($limit = false, $start=false) {
		
		$this->db->order_by("id", "desc");
		$this->db->where_not_in('role ', 1); // exclude admin
        $query = $this->db->get('users');
		return $query->result_array();
	}
	public function admin_login($data)
	{
		$this->db->where('role','1');
		$this->db->where('username', $data["username"]);
		$this->db->where('password', $data["password"]);
		$user=$this->db->get('users')->row_array();
		return $user;
	}
public function get_all_fund_requests()
	{	
		$this->db->order_by("id", "desc");
		$data = $this->db->get("topup_requests")->result_array();
		return $data;
	}
	public function get_all_exchange_requests()
	{	
		$this->db->order_by("id", "desc");
		$data = $this->db->get("exchange_requests")->result_array();
		return $data;
	}

	function get_row_exchange_by_id($id) {
		$result = $this->db->get_where('exchange_requests', array('id' => $id))->row_array();
		return $result;

	}

	 function update_exchange_status($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("exchange_requests", $data);
		return $resp;
	}
		public function get_all_withdrawal()
	{	    
	    $this->db->order_by("id", "desc");
		$data = $this->db->get("withdrawal_request")->result_array();
		
		return $data;
	}

	 function update_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdrawal_request", $data);
		return $resp;
	}
	public function update_admin($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("users", $data);
		return $resp;
	}
	public function get_admin_details($id)
	{
		$this->db->where("id", $id);
		$data=$this->db->get("users")->row_array();
		return $data;
	}
	public function get_support_messages() {
	    $this->db->order_by("id", "desc");
		return $this->db->where(array("status"=> 0))->where_in('to_id', array(NULL,1))->group_by("ticket_no")->get('support')->result_array();
	}
	public function get_support_admin_messages() {
	    $this->db->order_by("id", "desc");
		return $this->db->where(array("status"=> 2))->where_in('to_id', array(NULL,1))->group_by("ticket_no")->get('support')->result_array();
	}
	public function get_support_messages_resolved() {
	    $this->db->order_by("id", "desc");
		return $this->db->where(array("status"=> 1))->where_in('to_id', array(NULL,1))->group_by("ticket_no")->get('support')->result_array();
	}

	public function get_support_single_message($id) {
		return $this->db->where("id", $id)->get('support')->row_array();
	}

	public function get_support_reply($userId, $ticket_no) {
		return $this->db->where(array("ticket_no" => $ticket_no, "to_id" => $userId))->get('support')->row_array();
	}
	public function update_support($id, $data) {
		$this->db->where('id', $id);
		$this->db->update('support', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			return false;
		}
	}
	
	 function update_status($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("topup_requests", $data);
		return $resp;
	}

	function get_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_request")->row_array();
		return $result;
	}
	public function showcounter()
	{
		$data=$this->db->get("setting")->row_array();
		return $data;
	}
	public function counter($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('setting', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {			
			return false;
		}
		
	}
	public function create_contract($data)
	{
		if($this->db->insert('contracts',$data))
		{
			$id = $this->db->insert_id();
			$cid=$this->db->get_where('contracts',array('id'=>$id))->row_array();
			return $cid;
		}
		else{
			return false;
		}
	}
	public function get_all_contracts($limit = false, $start=false) {	
		$this->db->limit($limit, $start);	
		$this->db->order_by("id", "desc");		
        $query = $this->db->get('contracts');
		return $query->result_array();
	}

	public function getcontract($cid)
	{
		$this->db->where('contract_no', $cid);
		$query=$this->db->get('contracts')->row_array();

		return $query;
	}
	public function update_contract($contract, $data)
	{
		$this->db->where('contract_no', $contract);
		$this->db->update('contracts', $data);
		
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;

		}
	}
	function get_row_by_id($id) {
		$result = $this->db->get_where('topup_requests', array('id' => $id))->row_array();
		return $result;

	}
	function add_wallet_amount($userId, $data) {
		$user = $this->get_user_wallet($userId);
		if($user) {
			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount + {$data["wallet_amount"]} WHERE user_id = {$userId}");
			//$response = $query->result_array();
		} else {
			$response = $this->db->insert('topupwallet', $data); 
		}
		return $response;
	}
	function get_user_wallet($id) {
		return $this->db->get_where('topupwallet', array('user_id' => $id))->row_array();
	}
	function substract_wallet_amount($userId, $amount) {
		$user = $this->get_user_wallet($userId);
		$response = false;
		if($user) {
			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount - {$amount} WHERE user_id = {$userId}");
		}
		return $response;
	}

	function get_newuser($limit)
	{
		$this->db->order_by("id", "desc");
		$data = $this->db->get("users", $limit, 0)->result_array();
		return $data;
	}
	function addtransfer_entry($data)
	{
		$response = $this->db->insert("transferhistory", $data);
		return $response;
	}
	function get_withdraw_requests()
	{
		$response = $this->db->get("withdraw_request")->result_array();
		return $response;
	}

	function updateuser($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('users', $data);
		
		if($this->db->affected_rows()) {
			return true;
		}
		else {			
			return false;
		}
	}

	function getpackagecount($id)
	{
		$this->db->where("package_id", $id);
		$data = $this->db->get("sales")->num_rows();
			return $data ? $data : 0;
	}
	function usersleverage()
	{
		$response = $this->db->get("max_amount")->result_array();
		return $response;
	}
	function updateslip($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('withdraw_request', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;

		}
	}
	function get_single_withdrawal($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("withdraw_request")->row_array();
		return $query;
	}
	function get_blogs()
	{
		$query = $this->db->get("posts")->result_array();
		return $query;
	}
	function get_post_details($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("posts")->row_array();
		return $query;
	}
	function update_post($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('posts', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;
		}
	}
	function get_loans()
	{
		$query = $this->db->get("loan")->result_array();
		return $query;
	}
	function get_loan_details($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("loan")->row_array();
		return $query;
	}
	function update_loan($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('loan', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;

		}
	}

	function get_all_book_timing_requests(){
		$this->db->order_by("id", "Asc");
        $query = $this->db->get('timetable_requests');
		return $query->result_array();
	}

	function update_timetable_requests($id, $data){


			$this->db->where('id', $id);
		$this->db->update('timetable_requests', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;

		}
	}

	function update_setting_direct($data){


			$this->db->where('id', 1);
		$this->db->update('settings', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			
			return false;

		}
	}
	function get_settings(){

		$this->db->where("id" , 1);
		$query = $this->db->get("settings")->row_array();
		return $query;
	}

	 function get_withdraw_single_request($id) {
     	return $this->db->get_where('withdrawal_request', array('id' => $id))->row_array();
     } 
     function get_withdraw_accepted_all($uid=false) {
     	if($uid){
     		$this->db->where('user_id',$uid);
     	}
     	return $this->db->get_where('withdrawal_request', array('status' => 1))->result_array();
     }

    

	function daily_growth($data){
			return $this->db->insert('daily_growth',$data);
	}
	function get_daily_growth_by_userid($id){
		return $this->db->order_by('id','desc')->get_where('daily_growth', array('user_id' => $id))->row_array();
	}
	function get_daily_all_growth_by_userid($id){
		return $this->db->order_by('day','desc')->get_where('daily_growth', array('user_id' => $id))->result_array();
	}

	public function get_support_message_by_ticket($id) {
		return $this->db->where("ticket_no", $id)->get('support')->result_array();
	}

	public function update_chat_status($id, $data) {
		$this->db->where('ticket_no', $id);
		$this->db->update('support', $data);
		if($this->db->affected_rows()) {
			return true;
		}
		else {
			return false;
		}
	}
	public function getAllTopupBalance()
	{
// 		$this->db->distinct('user_id');
// 		$this->db->select('user_id');
		$query = $this->db->get("topupwallet")->result_array();
		return $query;
	}
 
     public function mark_messages_as_seen($ticket_no) {
        // Code to update messages as seen by ticket number
        $this->db->where('ticket_no', $ticket_no);
        $this->db->where('seen', 0);
        $this->db->update('support', ['seen' => 1]);
    }
    public function delete_user($id) {
    $this->db->where('id', $id);
    return $this->db->delete('users');
}


public function delete_users($user_ids) {
        $this->db->where_in('id', $user_ids); // Replace 'id' with your primary key column
        $this->db->delete('users');
    }

}


?>