<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #050505;
            /* Deepest black */
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            color: #ffffff;
        }

        .wrapper {
            width: 100%;
            background-color: #050505;
            padding: 60px 0;
            /* Creates a subtle purple/blue ambient glow in the background */
            background-image: radial-gradient(circle at 50% 0%, #261645 0%, #050505 50%);
        }

        .main-card {
            margin: 0 auto;
            width: 100%;
            max-width: 675px;
            background-color: #111111;
            border-radius: 28px;
            border: 1px solid #222222;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.5);
        }

        .header-gradient {
            height: 6px;
            background: linear-gradient(90deg, #a855f7, #3b82f6, #10b981);
        }

        .content {
            padding: 50px 40px;
        }

        .logo-box {
            text-align: center;
            margin-bottom: 40px;
        }

        h1 {
            font-size: 32px;
            font-weight: 800;
              color: #fff !important;
            margin-bottom: 24px;
            letter-spacing: -1px;
            text-align: center;
        }

        .status-badge {
            display: inline-block;
            padding: 6px 16px;
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
            border-radius: 100px;
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 20px;
        }

        p {
            font-size: 16px;
            line-height: 1.8;
            color: #a0a0a0;
            margin-bottom: 20px;
        }

        .action-area {
            text-align: center;
            padding: 30px 0;
        }

        .btn-primary {
            display: inline-block;
            background: #ffffff;
            color: #000000 !important;
            text-decoration: none;
            padding: 16px 40px;
            border-radius: 14px;
            font-weight: 700;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .footer {
            text-align: center;
            padding: 15px 00px;
            color: #444444;
            font-size: 13px;
        }

        .divider {
            height: 1px;
            background: #222222;
            margin: 30px 0;
        }

        /* Responsive */
        @media screen and (max-width: 600px) {
            .main-card {
                width: 92% !important;
                border-radius: 20px;
            }

            .content {
                padding: 40px 25px;
            }
        }
    </style>
    <style>
        .logo-text {
            font-size: 1.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            justify-content: center !important;
            text-decoration: none;
            transition: transform 0.3s ease;
            margin-bottom: 50px;
        }

        .logo-icon {
            width: 40px;
            height: 40px;
            border-radius: 0.5rem;
            background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <table class="main-card" cellpadding="0" cellspacing="0">
            <tr>
                <td class="header-gradient"></td>
            </tr>
            <tr>
                <td class="content">
                    <a href="<?= base_url() ?>" class="logo">
                         <img src="<?= base_url() ?>website/img/logo/logo.png" width="40" >
                        <!-- <span class="logo-text">SolStaker</span> -->
                    </a>

                    <div style="text-align: center;margin-bottom: 40px;">
                        <h1 class="logo-text">Welcome to Defilenders: <br> Your Gateway to Exceptional Ripple Staking Rewards</h1>
                    </div>

                    <p>Dear
                        <?= $user['username']; ?>,
                    </p>

                    <p>Join us at Defilenders.io, where we harness the cutting-edge technology of the Ripple blockchain
                        to offer a staking experience that's not just efficient, but extraordinarily rewarding. Our
                        platform combines the prowess of Ripple's high-throughput capabilities with an innovative
                        staking approach, ensuring you benefit from one of the most competitive rewards in the industry
                        staggering 2% monthly ROI. </p>
                    <p>Why Choose Defilenders.io?</p>

                    <p>- Exceptional Monthly Returns: With a monthly ROI of 2%, our platform stands out as a leader in
                        Ripple staking services, providing you with substantial growth potential for your digital
                        assets.</p>

                    <p>- State-of-the-art Security: At Defilenders.io, we prioritize your investment is safety with
                        top-tier security measures, ensuring your assets are protected at all times.</p>

                    <p>- User-centric Design: Navigate our platform with ease, thanks to an interface designed for both
                        novice and seasoned investors. With real-time analytics and transparent reporting, you're always
                        in control of your investments.</p>

                    <p style="margin-bottom:20px;">- Fast and Scalable: Leverage Ripple's renowned speed and
                        scalability. Enjoy lightning-fast transaction times and low fees, making your staking experience
                        smooth and cost-effective.</p>


                    <p style="margin-bottom:20px;">- Dedicated Support: Our expert team is here to support you 24/7.
                        Whether you're a first-time lander or a seasoned investor, we're here to ensure your staking
                        journey is seamless.</p>


                    <p style="margin-bottom:20px;">Get Started with Defilenders.io</p>


                    <p style="margin-bottom:20px;">Embark on your staking journey with Defilenders.io by simply
                        depositing your XRP tokens. Choose your staking preferences, and let our sophisticated system do
                        the rest. Start earning significant returns today and see your investments grow like never
                        before.</p>

                    <p style="margin-bottom:20px;">Join Our Community</p>

                    <p style="margin-bottom:20px;">By choosing Defilenders.io, you are not just investing in Ripple; you
                        are investing in a future where your digital assets work for you, yielding maximum returns. Join
                        our community of savvy investors and take the first step towards transforming your financial
                        landscape.</p>

                    <p style="margin-bottom:20px;">Visit us now at Defilenders.io and redefine what it means to lend
                        XRP. Embrace the power of Ripple and enjoy the rewards that come with it. Start your journey
                        towards financial excellence with Defilenders.io today.</p>

                    <p style="margin-top: 20px;">Kind Regards</p>
                    <p style="margin-top:15px">Team Defilenders</p>

                    <div class="divider"></div>
                    <div class="footer">
                        <p style="margin:0px; opacity: 0.5;">&copy; 2026 Defilenders. All Rights Reserved</p>
                    </div>

                </td>
            </tr>
        </table>


    </div>
</body>

</html>