<?php
/**
 * SOLSTAKER PRO - LIVE PRICE FEED
 */

// 1. Setup API (Error suppression added to prevent site breakage if API fails)
$url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,bnb,dogecoin,solana,tether&vs_currencies=usd";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) Chrome/91.0.4472.124 Safari/537.36');
curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 5 second timeout so site loads fast

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Default values if API fails
$sol_price = 0; $btc_price = 0; $eth_price = 0;

if ($http_code == 200 && $response) {
    $data = json_decode($response, true);
    $sol_price  = $data['solana']['usd'] ?? 0;
    $btc_price  = $data['bitcoin']['usd'] ?? 0;
    $eth_price  = $data['ethereum']['usd'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SolStaker | AI-Powered Staking</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --bg-dark: #0a0a0a;
            --bg-card: #141414;
            --primary: #9945FF; /* Solana Purple */
            --secondary: #14F195; /* Solana Green */
            --text-main: #ffffff;
            --text-muted: #a1a1aa;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --glow: 0 0 80px -20px rgba(153, 69, 255, 0.3);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            background-color: var(--bg-dark);
            color: var(--text-main);
            font-family: 'Plus Jakarta Sans', sans-serif;
            line-height: 1.6;
            overflow-x: hidden;
        }

        h1, h2, h3, h4 { font-family: 'Outfit', sans-serif; }
        a { text-decoration: none; transition: 0.3s; }
        
        /* Container */
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Utilities */
        .gradient-text {
            background: linear-gradient(135deg, var(--secondary) 0%, var(--primary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
        }
        
        .btn {
            display: inline-block;
            padding: 14px 32px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 1rem;
            cursor: pointer;
            text-align: center;
        }

        .btn-primary {
            background: linear-gradient(90deg, var(--primary), #7a2bf9);
            color: white;
            box-shadow: 0 4px 20px rgba(153, 69, 255, 0.4);
        }
        .btn-primary:hover { transform: translateY(-2px); box-shadow: 0 8px 30px rgba(153, 69, 255, 0.6); }

        /* HERO SECTION */
        .hero {
            position: relative;
            padding: 140px 0 100px;
            text-align: center;
            overflow: hidden;
        }

        .hero-bg-glow {
            position: absolute;
            top: -20%;
            left: 50%;
            transform: translateX(-50%);
            width: 800px;
            height: 800px;
            background: radial-gradient(circle, rgba(153,69,255,0.15) 0%, rgba(20,241,149,0.05) 50%, transparent 70%);
            z-index: -1;
            filter: blur(80px);
        }

        .hero-badge {
            display: inline-flex;
            align-items: center;
            padding: 8px 16px;
            background: rgba(255,255,255,0.05);
            border: 1px solid var(--glass-border);
            border-radius: 30px;
            font-size: 0.9rem;
            color: var(--secondary);
            margin-bottom: 24px;
        }

        .hero h1 {
            font-size: 3.5rem;
            line-height: 1.1;
            margin-bottom: 24px;
            font-weight: 700;
        }
        
        .hero-subtitle {
            font-size: 1.25rem;
            color: var(--text-muted);
            max-width: 600px;
            margin: 0 auto 40px;
        }

        /* LIVE MARKET STRIP */
        .market-strip {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
            margin-top: 60px;
        }
        
        .ticker-item {
            display: flex;
            align-items: center;
            gap: 10px;
            background: var(--glass-bg);
            border: 1px solid var(--glass-border);
            padding: 10px 20px;
            border-radius: 12px;
            backdrop-filter: blur(10px);
        }
        .ticker-label { font-weight: 700; color: #fff; }
        .ticker-price { color: var(--secondary); font-family: 'Monaco', monospace; }

        /* SECTIONS */
        .section { padding: 80px 0; }
        .section-header { text-align: center; margin-bottom: 60px; }
        .section-header h2 { font-size: 2.5rem; margin-bottom: 16px; }
        .section-header p { color: var(--text-muted); }

        /* CARDS GRID */
        .grid {
            display: grid;
            gap: 24px;
        }
        .grid-4 { grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); }
        .grid-2 { grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); }

        .card {
            background: var(--glass-bg);
            border: 1px solid var(--glass-border);
            padding: 32px;
            border-radius: 20px;
            transition: 0.3s;
            position: relative;
            overflow: hidden;
        }
        
        .card:hover {
            transform: translateY(-5px);
            background: rgba(255,255,255,0.05);
            border-color: rgba(255,255,255,0.2);
        }

        .card h3 { font-size: 1.25rem; margin-bottom: 12px; color: #fff; }
        .card p { color: var(--text-muted); font-size: 0.95rem; margin-bottom: 0; }
        
        .icon-box {
            width: 50px;
            height: 50px;
            background: rgba(20,241,149,0.1);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            font-size: 1.5rem;
        }

        /* HOW IT WORKS (Timeline Style) */
        .step-card {
            display: flex;
            gap: 20px;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        .step-number {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: #000;
            flex-shrink: 0;
        }

        /* ACCORDION */
        .accordion-item {
            background: var(--glass-bg);
            border: 1px solid var(--glass-border);
            border-radius: 12px;
            margin-bottom: 10px;
            overflow: hidden;
        }
        .accordion-header {
            width: 100%;
            padding: 20px;
            background: none;
            border: none;
            color: white;
            text-align: left;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
        }
        .accordion-content {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease;
            background: rgba(0,0,0,0.2);
        }
        .accordion-body { padding: 20px; color: var(--text-muted); font-size: 0.95rem; }
        .accordion-item.active .accordion-content { max-height: 300px; }
        .accordion-icon { transition: 0.3s; }
        .accordion-item.active .accordion-icon { transform: rotate(180deg); }

        /* FOOTER */
        .footer {
            background: #050505;
            padding: 80px 0 30px;
            border-top: 1px solid var(--glass-border);
            margin-top: 80px;
        }
        .footer-grid {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr;
            gap: 40px;
            margin-bottom: 60px;
        }
        .footer-logo { display: flex; align-items: center; gap: 10px; font-weight: 700; font-size: 1.5rem; margin-bottom: 20px; }
        .footer-links li { list-style: none; margin-bottom: 12px; }
        .footer-links a { color: var(--text-muted); font-size: 0.95rem; }
        .footer-links a:hover { color: var(--secondary); }
        .footer-bottom { text-align: center; border-top: 1px solid var(--glass-border); padding-top: 30px; color: #555; font-size: 0.85rem; }

        @media (max-width: 768px) {
            .hero h1 { font-size: 2.5rem; }
            .grid-4, .footer-grid { grid-template-columns: 1fr; }
            .market-strip { display: none; } /* Hide strip on mobile if needed */
        }
    </style>
</head>
<body>

    <section class="hero">
        <div class="hero-bg-glow"></div>
        
        <div class="container">
            <div class="hero-badge">
                ✨ Trusted by thousands of SOL stakers
            </div>

            <h1>
                Maximize Your <br> 
                <span class="gradient-text">Solana Rewards</span>
            </h1>

            <p class="hero-subtitle">
                The most advanced AI-driven staking platform. <br>
                Secure, Automated, and up to <span style="color:white; font-weight:700;">2% Monthly ROI</span>.
            </p>

            <div class="hero-cta">
                <a href="<?= base_url() ?>register" class="btn btn-primary">Start Earning Now →</a>
            </div>

            <div class="market-strip">
                <div class="ticker-item">
                    <img src="https://assets.coingecko.com/coins/images/4128/small/solana.png" width="20" alt="SOL">
                    <span class="ticker-label">SOL</span>
                    <span class="ticker-price">$<?= number_format($sol_price, 2) ?></span>
                </div>
                <div class="ticker-item">
                    <img src="https://assets.coingecko.com/coins/images/1/small/bitcoin.png" width="20" alt="BTC">
                    <span class="ticker-label">BTC</span>
                    <span class="ticker-price">$<?= number_format($btc_price, 2) ?></span>
                </div>
                <div class="ticker-item">
                    <img src="https://assets.coingecko.com/coins/images/279/small/ethereum.png" width="20" alt="ETH">
                    <span class="ticker-label">ETH</span>
                    <span class="ticker-price">$<?= number_format($eth_price, 2) ?></span>
                </div>
            </div>
        </div>
    </section>

    <section class="section">
        <div class="container">
            <div class="section-header">
                <h2>Why Choose <span class="gradient-text">SolStaker?</span></h2>
                <p>Engineered for performance, designed for simplicity.</p>
            </div>

            <div class="grid grid-4">
                <div class="card">
                    <div class="icon-box">📅</div>
                    <h3>Daily Payouts</h3>
                    <p>Rewards are calculated by AI and credited automatically to your dashboard every single day.</p>
                </div>

                <div class="card">
                    <div class="icon-box">🔓</div>
                    <h3>No Lock-ups</h3>
                    <p>Your assets, your control. Withdraw your principal or profits instantly without penalties.</p>
                </div>

                <div class="card">
                    <div class="icon-box">🤖</div>
                    <h3>AI Optimized</h3>
                    <p>Our trading algorithms scan the market 24/7 to find the highest yield opportunities.</p>
                </div>

                <div class="card">
                    <div class="icon-box">🛡️</div>
                    <h3>Bank-Grade Security</h3>
                    <p>Protected by multi-layer encryption and cold storage protocols. Your funds are safe.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="section" style="background: rgba(255,255,255,0.02);">
        <div class="container">
            <div class="grid grid-2" style="align-items: center; gap: 60px;">
                <div>
                    <h2>The Future of <br><span class="gradient-text">Intelligent Staking</span></h2>
                    <br>
                    <p style="color: var(--text-muted); margin-bottom: 20px;">
                        At SolStaker, we are pioneering the seamless integration of sophisticated artificial intelligence with the powerful Solana blockchain. 
                    </p>
                    <p style="color: var(--text-muted);">
                        Unlike traditional validators, our AI system dynamically adjusts staking pools based on network congestion and APY fluctuations, ensuring you always get the maximum possible return.
                    </p>
                </div>
                <div>
                    <div class="card" style="font-family: monospace; font-size: 0.9rem; border: 1px solid var(--primary);">
                        <div style="color: var(--secondary);">// AI System Status</div>
                        <div style="margin-top: 10px;">
                            <span style="color: #a1a1aa;">Target:</span> <span style="color: #fff;">SOL Network</span><br>
                            <span style="color: #a1a1aa;">Uptime:</span> <span style="color: var(--secondary);">99.99%</span><br>
                            <span style="color: #a1a1aa;">Current APY:</span> <span style="color: var(--primary);">Optimized</span><br>
                            <span style="color: #a1a1aa;">Security:</span> <span style="color: var(--secondary);">Active</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <a name="how"></a>
    <section class="section">
        <div class="container">
            <div class="section-header">
                <h2>How It <span class="gradient-text">Works</span></h2>
                <p>Start earning in 3 simple steps</p>
            </div>

            <div class="grid grid-2">
                <div class="card">
                    <div class="step-card">
                        <div class="step-number">1</div>
                        <div>
                            <h3>Create Account</h3>
                            <p>Register in seconds. No complex KYC required for basic tiers. Just verify your email.</p>
                        </div>
                    </div>
                    <div class="step-card">
                        <div class="step-number">2</div>
                        <div>
                            <h3>Deposit SOL</h3>
                            <p>Send SOL to your unique deposit address. The AI detects the funds and starts working instantly.</p>
                        </div>
                    </div>
                    <div class="step-card">
                        <div class="step-number">3</div>
                        <div>
                            <h3>Watch it Grow</h3>
                            <p>Log in daily to see your rewards. Withdraw your earnings or compound them for faster growth.</p>
                        </div>
                    </div>
                </div>
                
                <div class="card" style="background: linear-gradient(135deg, rgba(20,241,149,0.05), rgba(153,69,255,0.05)); display: flex; flex-direction: column; justify-content: center; align-items: center; text-align: center;">
                    <h3>Ready to maximize your portfolio?</h3>
                    <p style="margin: 20px 0;">Join the fastest growing staking community on Solana.</p>
                    <a href="<?= base_url() ?>register" class="btn btn-primary" style="width: 100%;">Create Free Account</a>
                </div>
            </div>
        </div>
    </section>

    <a name="faq"></a>
    <section class="section">
        <div class="container" style="max-width: 800px;">
            <div class="section-header">
                <h2>Frequently Asked <span class="gradient-text">Questions</span></h2>
            </div>

            <div class="accordion">
                <div class="accordion-item">
                    <button class="accordion-header" onclick="toggleAccordion(this)">
                        <span>What is the minimum deposit?</span>
                        <span class="accordion-icon">▼</span>
                    </button>
                    <div class="accordion-content"><div class="accordion-body">You can start staking with as little as 10 SOL. This allows users of all levels to experience our AI-driven rewards system.</div></div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header" onclick="toggleAccordion(this)">
                        <span>Is there a lock-up period?</span>
                        <span class="accordion-icon">▼</span>
                    </button>
                    <div class="accordion-content"><div class="accordion-body">No. SolStaker believes in total liquidity. You can withdraw your initial capital and your profits at any time instantly.</div></div>
                </div>

                <div class="accordion-item">
                    <button class="accordion-header" onclick="toggleAccordion(this)">
                        <span>How are rewards calculated?</span>
                        <span class="accordion-icon">▼</span>
                    </button>
                    <div class="accordion-content"><div class="accordion-body">Rewards are generated through high-frequency validation strategies and AI-arbitrage on the Solana network. Profits are distributed daily based on your share of the pool.</div></div>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-grid">
                <div class="footer-brand">
                    <a href="<?= base_url() ?>" class="footer-logo">
                        <svg width="28" height="28" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5.5 20.5L10 16L5.5 11.5L7 10L13 16L7 22L5.5 20.5Z" fill="#9945FF" />
                            <path d="M14 11H26V13H14V11Z" fill="#14F195" />
                            <path d="M14 19H26V21H14V19Z" fill="#00D4FF" />
                        </svg>
                        <span style="color: white;">SolStaker</span>
                    </a>
                    <p style="color: var(--text-muted); font-size: 0.9rem;">
                        The premier destination for automated Solana staking. Secure, transparent, and profitable.
                    </p>
                </div>

                <div class="footer-section">
                    <h4 style="color: white; margin-bottom: 20px;">Platform</h4>
                    <ul class="footer-links">
                        <li><a href="<?= base_url() ?>login">Login</a></li>
                        <li><a href="<?= base_url() ?>register">Register</a></li>
                        <li><a href="#how">How it Works</a></li>
                    </ul>
                </div>

                <div class="footer-section">
                    <h4 style="color: white; margin-bottom: 20px;">Legal</h4>
                    <ul class="footer-links">
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                        <li><a href="#">Risk Disclosure</a></li>
                    </ul>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>© 2026 SolStaker. All rights reserved. Built on <span style="color: var(--secondary); font-weight: 600;">Solana</span>.</p>
            </div>
        </div>
    </footer>

    <script>
        function toggleAccordion(element) {
            const item = element.parentElement;
            const isActive = item.classList.contains('active');
            
            // Close all others
            document.querySelectorAll('.accordion-item').forEach(acc => {
                acc.classList.remove('active');
            });

            // Toggle current
            if (!isActive) {
                item.classList.add('active');
            }
        }

        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu-btn');
            menu.classList.toggle('active');
        }
    </script>
</body>
</html>