<?php



/**

 * SOLSTAKER LIVE PRICE FEED

 * Fetches data from CoinGecko API using cURL

 */



// 1. Setup the API URL

$url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,bnb,dogecoin,solana,ripple,tether&vs_currencies=usd";



// 2. Initialize cURL

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $url);

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);



// 3. Set a User-Agent to prevent "403 Forbidden" errors

curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) Chrome/91.0.4472.124 Safari/537.36');



// 4. Execute and close

$response = curl_exec($ch);

curl_close($ch);



// 5. Decode the data

$data = json_decode($response, true);
// echo '<pre>';
// print_r($data);
// exit;
// 6. Extract prices with fallbacks (default to 0 if API fails)

$sol_price  = $data['solana']['usd'] ?? 0;

$btc_price  = $data['bitcoin']['usd'] ?? 0;

$eth_price  = $data['ethereum']['usd'] ?? 0;

$bnb_price  = $data['binancecoin']['usd'] ?? 0;

$dog_price  = $data['dogecoin']['usd'] ?? 0;
$ripple_price  = $data['ripple']['usd'] ?? 0;

$usdt_price = $data['tether']['usd'] ?? 0;

?>
<style>
    .calculator-box {

        max-width: 500px;

        margin: 0px auto;


        background: transparent;

        border-radius: 12px;

        box-shadow: 0px 25px 50px rgba(11, 23, 69, 0.07);

    }



    .slider {

        width: 100%;

    }



    .faq-que-details .card .card-header button {

        background-color: transparent !important;

        /* box-shadow: 0px 25px 50px rgba(11, 23, 69, 0.07); */

    }



    .faq-que-details .card {

        background-color: transparent !important;

        box-shadow: 0px 25px 50px rgba(11, 23, 69, 0.07);

    }



    .info-box {

        /* background-color: #f0f4f8; */

        padding: 15px;

        border-radius: 8px;

        margin-top: 20px;

        font-size: 0.95rem;

    }

    .d-flex {
        display: flex !important;
    }

    .justify-content-between {
        justify-content: space-between;
    }

    ul li {

        font-size: 16px;

    }
</style>
<!-- Hero Section -->

<section class="hero">

    <div class="hero-bg">

        <div class="bg-gradient-1"></div>

        <div class="bg-gradient-2"></div>

        <div class="bg-gradient-3"></div>

    </div>



    <div class="container d-none">

        <div class="hero-content">

            <div class="hero-badge" style="margin-top:70px">

                ✨ Trusted by thousands of XRP lenders

            </div>



            <h1>

                Welcome to Defilenders <br>

                <span class="gradient-text">Earn Smarter with XRP.</span>

            </h1>



            <p class="hero-subtitle">

                Put your idle XRP to work and generate up to 2% monthly returns. No lock-ups. No hidden terms. Just complete control over your crypto.

            </p>

            <!-- <p class="mobile_none" style="    margin-bottom: 20px;max-width: 800px">At <strong>SolStaker</strong>SolStaker, we are pioneering the seamless integration of <strong>cutting-edge artificial intelligence</strong> with the power of the <strong>Solana blockchain</strong>, creating an <strong>unmatched staking experience</strong>. By combining Solana’s high-speed network with <strong>AI-driven staking strategies</strong>, we optimize returns beyond traditional staking platforms—offering <strong>efficiency, security, and profitability at scale</strong>

            </p> -->

            <div class="hero-cta">

                <a href="<?= base_url() ?>register" class="btn btn-primary">Start Earning →</a>

                <!-- <a href="about.html" class="btn btn-secondary">How It Works</a> -->

            </div>

            <!-- <h4 class="gradient-text" style="margin-top:40px;">Solana’s Top Growing Ai Staking Platfrom</h4> -->

            <!-- <div class="hero-stats" style="display: flex;justify-content:center;align-items:center;margin-top:15px;">

                <div class="stat-card">

                    <div class="stat-valu">1</div>

                    <div class="stat-label">SOL</div>

                </div>

                <div style="font-size: 30px;">=</div>

                <div class="stat-card">

                    <div class="stat-valu"><?php echo $ripple_price; ?></div>

                    <div class="stat-label">USD</div>

                </div>

            </div> -->

        </div>

    </div>

</section>
<section>
    <div class="container" style="max-width: 560px;margin-top:50px">
        <div class="card">



            <div class="col-lg-12 text-center text-md-left second">



                <div class="calculator-box">

                    <h4 class="text-center mb-4">See How Much You Can Earn</h4>



                    <div class="mb-3">

                        <!--<label for="xrpAmount" class="form-label" style="color: #072e65;">You lend:</label>-->

                        <div class="input-group d-flex">

                            <input type="number" class="input" id="xrpAmount" value="100000" min="1000" max="3000000" step="1000" style="width: 100%;">

                            <span class="btn btn-primary">XRP</span>

                        </div>

                    </div>



                    <div class="mb-4">

                        <input type="range" class="form-range slider" id="xrpSlider" min="1000" max="3000000" step="1000" value="100000">

                        <div class="d-flex justify-content-between text-muted small">

                            <span>1,000</span>

                            <span>3,000,000</span>

                        </div>

                    </div>



                    <div class="mb-3">

                        <h5>You earn (monthly): <span class="gradient-text" id="monthlyEarnings">5,000</span> XRP</h5>

                    </div>



                    <div class="info-box">

                        Interest is calculated at <strong>2% per month</strong> and reflected daily. You can withdraw your funds at any time.

                    </div>

                </div>



            </div><!-- /.col -->

        </div>
    </div>
</section>


<!-- Benefits Section -->

<a name="why"></a>

<section class="section">

    <div class="container">

        <div class="section-header" style="position: relative;">
            <!-- <img src="<?= base_url() ?>website/img/powered.png" class="powered-img" style="position: absolute;    width: 81px;  top: -60px;left:0;  border-radius: 8px; border: 1px solid rgb(153, 69, 253);" alt=""> -->
            <h2>

                Why Choose <span class="gradient-text">Defilenders</span>
            </h2>

            <p>The simplest and most rewarding way to lend your XRP</p>

        </div>
        <div class="grid grid-4">

            <div class="card">

                <!-- <div class="card-icon">◈</div> -->

                <h3>High Returns & Flexible Investment</h3>

                <p>Earn a fixed 2% monthly return (24% APR) through our fully automated XRP lending model. With a minimum deposit of 1,000 XRP, you can start generating consistent returns while maintaining flexibility and full access to your funds.
                </p>


            </div>



            <div class="card">

                <!-- <div class="card-icon">⟠</div> -->

                <h3>Advanced Technology Infrastructure</h3>

                <p>Our platform is powered by Ripple-based infrastructure, ensuring speed, stability, and network reliability. The automated system efficiently matches lenders with verified borrowers for seamless performance.
                </p>


            </div>



            <div class="card">

                <!-- <div class="card-icon">⚡</div> -->

                <h3>Security & Risk Protection</h3>

                <p>We prioritize security with bank-grade encryption, cold storage, multi-factor authentication, and real-time monitoring. Overcollateralized lending, automated risk controls, and insurance-backed reserves further protect lender funds.
                </p>


            </div>



            <div class="card">

                <!-- <div class="card-icon">◉</div> -->

                <h3>Verified Borrower Network</h3>

                <p>All borrowers undergo strict screening and verification processes before accessing funds. This ensures responsible lending practices and maintains the integrity and sustainability of the platform.
                </p>

            </div>

        </div>

    </div>

</section>



<section>

    <div class="container">

        <div class="hero-stats" style="display: flex;justify-content:center;align-items:center;margin-top:15px;">
            <div class="stat-card">
                <div class="stat-valu">1</div>
                <div class="stat-label">XRP</div>
            </div>
            <div style="font-size: 30px;">=</div>
            <div class="stat-card">
                <div class="stat-valu"><?php echo $data['ripple']['usd']; ?></div>
                <div class="stat-label">USD</div>
            </div>
        </div>

    </div>

</section>

<!-- How It Works Section -->

<a name="how"></a>

<section class="section" style="background: linear-gradient(to bottom, transparent, rgba(255,255,255,0.02));">

    <div class="container">

        <div class="section-header">

            <h2>How <span class="gradient-text">Defilenders</span> Works</h2>

            <!-- <p>Five simple steps to start earning passive income</p> -->

        </div>



        <div style="max-width: 900px; margin: 0 auto;">

            <div class="card mb-3">

                <div style="display: flex; gap: 1.5rem; align-items: start;">

                    <!-- <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div> -->

                    <div>

                        <h3>Register & Verify</h3>

                        <p>Create your account, verify your email address, and securely access your personalized dashboard to manage your activity and settings.</p>

                    </div>

                </div>

            </div>



            <div class="card mb-3">

                <div style="display: flex; gap: 1.5rem; align-items: start;">

                    <!-- <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div> -->

                    <div>

                        <h3> Deposit Funds </h3>

                        <p>Transfer a minimum of 1,000 XRP into your secure lending wallet to activate your account, start earning competitive returns, and maintain full control over your funds at all times.</p>

                    </div>

                </div>

            </div>



            <div class="card mb-3">

                <div style="display: flex; gap: 1.5rem; align-items: start;">

                    <!-- <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div> -->

                    <div>

                        <h3>Start Earning</h3>

                        <p>Your XRP begins generating passive income as soon as it is securely matched with verified borrowers on the platform, allowing you to earn consistent returns automatically while maintaining full transparency, flexibility, and complete control over your funds at all times.</p>

                    </div>

                </div>

            </div>



            <div class="card mb-3">

                <div style="display: flex; gap: 1.5rem; align-items: start;">

                    <!-- <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div> -->

                    <div>

                        <h3>Track & Withdraw</h3>

                        <p>Monitor your interest earnings in real time through your secure dashboard, track performance with complete transparency, and withdraw your funds anytime you choose without lock-in periods, restrictions, or hidden conditions, ensuring full flexibility and total control over your crypto assets.</p>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section>



<!-- Testimonials Section -->

<!-- <section class="section">

    <div class="container">

        <div class="section-header">

            <h2>Trusted by <span class="gradient-text">Thousands</span></h2>

            <p>Join our community of satisfied stakers</p>

        </div>



        <div class="grid grid-3">

            <div class="card">

                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>

                <p style="margin-bottom: 1.5rem;">"SolStaker made staking incredibly simple. I earn daily rewards without any technical knowledge. The interface is beautiful and everything just works."</p>

                <div style="display: flex; align-items: center; gap: 0.75rem;">

                    <div style="font-size: 2rem;">👩‍💼</div>

                    <div>

                        <div style="font-weight: 600;">Sarah Chen</div>

                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">Crypto Investor</div>

                    </div>

                </div>

            </div>



            <div class="card">

                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>

                <p style="margin-bottom: 1.5rem;">"Best staking platform I've used. No lockups, instant withdrawals, and competitive APY. The dashboard shows everything I need at a glance."</p>

                <div style="display: flex; align-items: center; gap: 0.75rem;">

                    <div style="font-size: 2rem;">👨‍💻</div>

                    <div>

                        <div style="font-weight: 600;">Marcus Rodriguez</div>

                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">DeFi Enthusiast</div>

                    </div>

                </div>

            </div>



            <div class="card">

                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>

                <p style="margin-bottom: 1.5rem;">"I've been staking with SolStaker for 6 months. Rewards are consistent, support is excellent, and I love the transparency. Highly recommended!"</p>

                <div style="display: flex; align-items: center; gap: 0.75rem;">

                    <div style="font-size: 2rem;">👩‍🔬</div>

                    <div>

                        <div style="font-weight: 600;">Emily Watson</div>

                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">Long-term Holder</div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section> -->



<!-- FAQ Section -->

<a name="faq"></a>

<section class="section">

    <div class="container">

        <div class="section-header">

            <h2>Frequently Asked <span class="gradient-text">Questions</span></h2>

            <p>Everything you need to know about lending with Defilenders</p>

        </div>



        <div class="accordion">

            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span>What is XRP lending?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        XRP lending enables you to provide your XRP to carefully vetted, pre-approved borrowers in exchange for predictable monthly interest payments. It offers a secure, transparent, and efficient way to generate steady passive income while retaining flexibility and control over your digital assets.

                    </div>

                </div>

            </div>



            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span>How much interest do I earn?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        You earn a fixed 2% monthly interest, equivalent to 24% annual percentage rate (APR). Your interest is calculated automatically and credited directly to your main wallet on the platform, ensuring consistent earnings, full transparency, and seamless access to your growing balance.

                    </div>

                </div>

            </div>



            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span>Is there a minimum deposit to start?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        Yes, the minimum deposit required to begin lending is 1,000 XRP.

                    </div>

                </div>

            </div>



            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span> How do I get started?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        Register on the platform, verify your email, and deposit at least 1,000 XRP into your account. Once funded, your XRP is automatically and securely allocated to verified borrowers, allowing you to start earning interest without manual intervention.

                    </div>

                </div>

            </div>



            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span> When will I start seeing earnings?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        You will receive your first daily interest reward 24 hours after making your deposit. After that, rewards are credited to your account balance every day, calculated proportionally based on the fixed 2% monthly interest rate.

                    </div>

                </div>

            </div>



            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span> Is it safe? What happens if borrowers don’t repay?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">

                        Security is our highest priority. We implement rigorous borrower screening, require overcollateralization, and apply advanced risk management protocols to safeguard your funds. Additionally, a portion of the platform’s revenue is allocated to an insurance reserve fund designed to protect lenders in the rare event of borrower defaults.



                    </div>

                </div>

            </div>

            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span>Are my funds locked?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">
                        No. You can withdraw your XRP at any time without penalties, lock-in periods, or waiting restrictions, giving you complete flexibility and uninterrupted access to your funds whenever you choose.
                    </div>

                </div>

            </div>
            <div class="accordion-item">

                <button class="accordion-header" onclick="toggleAccordion(this)">

                    <span>Are there any fees?</span>

                    <span class="accordion-icon">▼</span>

                </button>

                <div class="accordion-content">

                    <div class="accordion-body">
                        There are no deposit or withdrawal fees on the platform. However, a small percentage of the interest you earn is retained as a service fee to support platform operations, security infrastructure, and ongoing system maintenance.
                    </div>

                </div>

            </div>

        </div>



        <!-- <div class="text-center mt-4">

                <p style="color: rgba(255,255,255,0.6); margin-bottom: 1.5rem;">Still have questions?</p>

                <a href="faq.html" class="btn btn-secondary">View All FAQs</a>

            </div> -->

    </div>

</section>



<!-- Footer -->

<footer class="footer">

    <div class="container">

        <div class="footer-grid">

            <div class="footer-brand">

                <a href="<?= base_url() ?>" class="logo">

                    <img src="<?= base_url() ?>website/img/logo/logo.png" width="40" alt="logo">

                    <span class="logo-text">Defilenders</span>

                </a>

                <p> Put your idle XRP to work and generate up to 2% monthly returns. No lock-ups. No hidden terms. Just complete control over your crypto.</p>

            </div>



            <!-- <div class="footer-section">

                    <h3>Product</h3>

                    <ul class="footer-links">

                        <li><a href="dashboard.html">Dashboard</a></li>

                        <li><a href="deposit.html">Deposit</a></li>

                        <li><a href="withdraw.html">Withdraw</a></li>

                        <li><a href="about.html">How It Works</a></li>

                    </ul>

                </div> -->



            <div class="footer-section">

                <h3>Quick Links</h3>

                <ul class="footer-links">



                    <li><a href="<?= base_url() ?>login">Sign In</a></li>

                    <li><a href="<?= base_url() ?>register">Sign Up</a></li>

                    <li><a href="<?= base_url() ?>">Home</a></li>

                </ul>

            </div>



            <!-- <div class="footer-section">

                <h3>Company</h3>

                <ul class="footer-links">

                    <li><a href="#">Terms of Use</a></li>

                    <li><a href="#">Privacy Policy</a></li>

                    <li><a href="#">Law Enforcement Request Guidelines</a></li>



                </ul>

            </div> -->

        </div>

        <div class="footer-bottom" style="border-top: none; padding-top: 0;">

            <p>© 2026 Defilenders. All rights reserved.</p>

            <p>Built on <span class="gradient-text" style="font-weight: 600;">Ripple</span></p>

        </div>

    </div>

</footer>



<script src="<?= base_url() ?>website/js/main.js"></script>





<script>
    const xrpInput = document.getElementById('xrpAmount');

    const xrpSlider = document.getElementById('xrpSlider');

    const earningsDisplay = document.getElementById('monthlyEarnings');



    function updateEarnings(value) {

        const earnings = value * 0.02;

        earningsDisplay.textContent = earnings.toLocaleString(undefined, {

            maximumFractionDigits: 0

        });

    }



    xrpInput.addEventListener('input', () => {

        let value = parseInt(xrpInput.value);

        value = Math.min(Math.max(value, 1000), 3000000); // constrain value

        xrpSlider.value = value;

        updateEarnings(value);

    });



    xrpSlider.addEventListener('input', () => {

        const value = parseInt(xrpSlider.value);

        xrpInput.value = value;

        updateEarnings(value);

    });



    // Initialize

    updateEarnings(parseInt(xrpInput.value));
</script>



</body>



</html>