<style>
    :root {
        --solana-purple: #9945FF;
        --solana-cyan: #14F195;
        --glass-bg: rgba(255, 255, 255, 0.05);
        --glass-border: rgba(153, 69, 255, 0.3);
    }

    .profile-container {
        padding: 160px 20px 60px;
        max-width: 1200px;
        margin: 0 auto;
        color: white;
        font-family: 'Inter', sans-serif;
    }

    .grid-layout {
        display: grid;
        grid-template-columns: 1fr 2fr;
        gap: 25px;
    }

    /* Card Styling */
    .custom-card {
        background: var(--glass-bg);
        border: 1px solid var(--glass-border);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        padding: 30px;
        position: relative;
    }

    /* Profile Avatar Section */
    .avatar-wrapper {
        text-align: center;
        margin-bottom: 20px;
    }

    .avatar-circle {
        width: 160px;
        height: 160px;
        border-radius: 50%;
        padding: 3px;
        background: linear-gradient(135deg, var(--solana-purple), var(--solana-cyan));
        margin: 0 auto 15px;
    }

    .avatar-circle img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
        background: #0b0b0b;
    }

    /* Form Elements */
    .input-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 20px;
    }

    .input-field {
        margin-bottom: 15px;
    }

    .input-label {
        display: block;
        font-size: 0.85rem;
        color: rgba(255, 255, 255, 0.6);
        margin-bottom: 8px;
    }

    .custom-input {
        width: 100%;
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid var(--glass-border);
        padding: 12px 15px;
        border-radius: 10px;
        color: white;
        font-size: 1rem;
        transition: 0.3s;
    }

    .custom-input:focus {
        border-color: var(--solana-cyan);
        outline: none;
        box-shadow: 0 0 10px rgba(20, 241, 149, 0.1);
    }

    /* Phone Input Layout */
    .phone-flex {
        display: flex;
        gap: 0;
    }

    .country-select {
        width: 100px;
        border-radius: 10px 0 0 10px;
        border-right: none;
        background: rgba(0, 0, 0, 0.3);
        color: white;
        padding-left: 10px;
    }

    .phone-input {
        border-radius: 0 10px 10px 0;
    }

    /* Custom Button */
    .btn-action {
        background: linear-gradient(135deg, var(--solana-purple), #7a32cc);
        color: white;
        border: none;
        padding: 12px 25px;
        border-radius: 10px;
        cursor: pointer;
        font-weight: 600;
        transition: 0.3s;
        text-decoration: none;
        display: inline-block;
    }

    .btn-action:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(153, 69, 255, 0.4);
    }

    .btn-outline {
        background: transparent;
        border: 1px solid rgba(255, 77, 77, 0.5);
        color: #ff4d4d;
        margin-top: 10px;
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {

        .grid-layout,
        .input-row {
            grid-template-columns: 1fr;
        }

        .profile-container {
            padding-top: 80px;
        }
    }
</style>

<div class="profile-container">
    <!-- <h2 style="text-align: center; margin-bottom: 40px; font-weight: 800; font-size: 2rem;">
        Account <span style="">Settings</span>
    </h2> -->
    <div class="text-center" style="margin-bottom: 30px;">
        <?php if ($this->session->flashdata()) {
            echo Helpers::showFlash($this->session->flashdata("response"));
        } ?>
    </div>
    <div class="grid-layout">

        <div class="custom-card avatar-wrapper">
            <div class="avatar-circle">
                <?php if (empty($data['user']['image'])) : ?>
                    <img src="<?= base_url(); ?>website/img/logo/xrp.png">
                <?php else : ?>
                    <img src="<?= base_url() ?>uploads/files/profile/<?= $data['user']['id']; ?>/<?= $data['user']['image']; ?>">
                <?php endif; ?>
            </div>
            <h3 style="margin: 10px 0 5px;"><?= $data['user']['username']; ?></h3>

            <a href="<?= base_url(); ?>profile_picture" class="btn-action" style="width: 80%;">Update Photo</a>

            <?php if (!empty($data['user']['image'])) : ?>
                <form action="<?= base_url('member/profile_picture'); ?>" method="POST">
                    <button type="submit" name="remove" class="btn-action btn-outline" style="width: 80%;">Remove Profile</button>
                </form>
            <?php endif; ?>
        </div>

        <div class="custom-card">
            <h4 style="margin-top: 0; margin-bottom: 25px;">Personal Details</h4>

            <form method="post">
                <div class="input-row">
                    <div class="input-field">
                        <label class="input-label">Full Name</label>
                        <input type="text" class="custom-input" name="full_name" value="<?= $data['user']['full_name']; ?>">
                    </div>
                    <div class="input-field">
                        <label class="input-label">Username</label>
                        <input type="text" class="custom-input" value="<?= $data['user']['username']; ?>" readonly style="opacity: 0.6; cursor: not-allowed;">
                    </div>
                </div>

                <div class="input-row">
                    <div class="input-field">
                        <label class="input-label">Email Address</label>
                        <input type="email" name="email" class="custom-input" value="<?= $data['user']['email']; ?>" readonly style="opacity: 0.6; cursor: not-allowed;">
                    </div>
                    <div class="input-field">
                        <label class="input-label">Phone Number</label>
                        <div class="phone-flex">
                            <select name="country_code" class="custom-input country-select">
                                <?php
                                $country_codes = [
                                    '+1', '+7', '+20', '+27', '+30', '+31', '+32', '+33', '+34', '+36', '+39', '+40', '+41', '+43', '+44',
                                    '+45', '+46', '+47', '+48', '+49', '+51', '+52', '+53', '+54', '+55', '+56', '+57', '+58', '+60', '+61',
                                    '+62', '+63', '+64', '+65', '+66', '+81', '+82', '+84', '+86', '+90', '+91', '+92', '+93', '+94', '+95',
                                    '+98', '+211', '+212', '+213', '+216', '+218', '+220', '+221', '+222', '+223', '+224', '+225', '+226',
                                    '+227', '+228', '+229', '+230', '+231', '+232', '+233', '+234', '+235', '+236', '+237', '+238', '+239',
                                    '+240', '+241', '+242', '+243', '+244', '+245', '+246', '+248', '+249', '+250', '+251', '+252', '+253',
                                    '+254', '+255', '+256', '+257', '+258', '+260', '+261', '+262', '+263', '+264', '+265', '+266', '+267',
                                    '+268', '+269', '+290', '+291', '+297', '+298', '+299', '+350', '+351', '+352', '+353', '+354', '+355',
                                    '+356', '+357', '+358', '+359', '+370', '+371', '+372', '+373', '+374', '+375', '+376', '+377', '+378',
                                    '+380', '+381', '+382', '+383', '+385', '+386', '+387', '+389', '+420', '+421', '+423', '+500', '+501',
                                    '+502', '+503', '+504', '+505', '+506', '+507', '+508', '+509', '+590', '+591', '+592', '+593', '+594',
                                    '+595', '+596', '+597', '+598', '+599', '+670', '+672', '+673', '+674', '+675', '+676', '+677', '+678',
                                    '+679', '+680', '+681', '+682', '+683', '+685', '+686', '+687', '+688', '+689', '+690', '+691', '+692',
                                    '+850', '+852', '+853', '+855', '+856', '+880', '+886', '+960', '+961', '+962', '+963', '+964', '+965',
                                    '+966', '+967', '+968', '+970', '+971', '+972', '+973', '+974', '+975', '+976', '+977', '+992', '+993',
                                    '+994', '+995', '+996', '+998'
                                ];
                                // Check if 'country_code' is set in $data['user']
                                $selected_country_code = isset($data['user']['country_code']) ? $data['user']['country_code'] : '';
                                ?>
                                <?php foreach ($country_codes as $code) : ?>
                                    <option value="<?= $code ?>" <?= $selected_country_code == $code ? 'selected' : ''; ?>>
                                        <?= $code ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <input type="number" class="custom-input phone-input" name="phone_number" value="<?= $data['user']['phone_number']; ?>">
                        </div>
                    </div>
                </div>

                <div style="margin-top: 20px; text-align: right;">
                    <button type="submit" class="btn-action" style="padding-left: 50px; padding-right: 50px;">Save Profile</button>
                </div>
            </form>
        </div>
    </div>
</div>