<style>
    .upload-container {
        padding: 120px 20px 60px;
        max-width: 600px;
        margin: 0 auto;
        color: white;
    }

    .upload-card {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(153, 69, 255, 0.3);
        backdrop-filter: blur(10px);
        border-radius: 20px;
        padding: 40px;
        text-align: center;
    }

    .file-input-wrapper {
        position: relative;
        width: 100%;
        margin: 20px 0;
    }

    /* Custom Styled File Input */
    .custom-file-input {
        width: 100%;
        padding: 40px 20px;
        border: 2px dashed rgba(20, 241, 149, 0.3);
        border-radius: 15px;
        background: rgba(0, 0, 0, 0.2);
        color: rgba(255, 255, 255, 0.6);
        cursor: pointer;
        transition: 0.3s;
    }

    .custom-file-input:hover {
        border-color: #14F195;
        background: rgba(20, 241, 149, 0.05);
    }

    .btn-upload {
        background: linear-gradient(135deg, #9945FF, #7a32cc);
        color: white;
        border: none;
        padding: 15px 40px;
        border-radius: 12px;
        font-weight: 700;
        cursor: pointer;
        width: 100%;
        font-size: 1rem;
        transition: 0.3s;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .btn-upload:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 20px rgba(153, 69, 255, 0.4);
    }

    .btn-remove {
        background: transparent;
        color: #ff4d4d;
        border: 1px solid rgba(255, 77, 77, 0.3);
        padding: 12px;
        border-radius: 12px;
        width: 100%;
        margin-top: 15px;
        cursor: pointer;
        font-size: 0.9rem;
        transition: 0.3s;
    }

    .btn-remove:hover {
        background: rgba(255, 77, 77, 0.1);
        border-color: #ff4d4d;
    }
</style>
<div class="content-body">
    <div class="upload-container">

        <div style="margin-bottom: 20px; text-align: center;">
            <?php if ($this->session->flashdata()) {
                echo Helpers::showFlash($this->session->flashdata("response"));
            } ?>
        </div>

        <div class="upload-card">
            <h2 style="font-weight: 700; margin-bottom: 5px;">Profile Picture</h2>
            <p style="color: rgba(255,255,255,0.5); font-size: 0.9rem; margin-bottom: 30px;">
                Update your account avatar (JPG, PNG)
            </p>

            <form action="<?= base_url(); ?>member/profile_picture" method="POST" enctype="multipart/form-data">
                <div class="file-input-wrapper">
                    <label class="input-label" style="display: block; text-align: left; margin-bottom: 10px; font-size: 0.85rem; color: rgba(255,255,255,0.6);">
                        Choose Image File
                    </label>
                    <input type="file" name="fileupload" class="custom-file-input" accept=".jpg, .jpeg, .png" required>
                </div>

                <button type="submit" name="submit" class="btn-upload">Update Now</button>
            </form>

            <?php if (!empty($GetUser['image'])) { ?>
                <form action="<?= base_url('member/profile_picture'); ?>" method="POST">
                    <button type="submit" name="remove" class="btn-remove">
                        Remove Current Picture
                    </button>
                </form>
            <?php } ?>

            <div style="margin-top: 25px;">
                <a href="<?= base_url(); ?>profile" style="color: rgba(255,255,255,0.4); text-decoration: none; font-size: 0.85rem;">
                    ← Back to Profile
                </a>
            </div>
        </div>
    </div>
</div>