<style>
    /* Chat Container Styling */
    .chat-card {
        background-color: #1a1a1a;
        border: 1px solid rgba(153, 69, 255, 0.3);
        border-radius: 1.5rem;
        overflow: hidden;
        display: flex;
        flex-direction: column;
        height: 70vh;
        /* Fixed height for scrolling */
        box-shadow: 0 0 30px rgba(153, 69, 255, 0.1);
    }

    .chat-header-custom {
        padding: 20px 25px;
        background: rgba(153, 69, 255, 0.1);
        border-bottom: 1px solid rgba(153, 69, 255, 0.2);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .chat-body-custom {
        flex: 1;
        overflow-y: auto;
        padding: 25px;
        background: radial-gradient(circle at top right, rgba(153, 69, 255, 0.05), transparent);
    }

    /* Message Bubbles */
    .message-wrapper {
        margin-bottom: 20px;
        display: flex;
        flex-direction: column;
    }

    /* Support Message (Left) */
    .msg-left {
        align-items: flex-start;
    }

    .msg-left .bubble {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        color: white;
        border-radius: 0 15px 15px 15px;
    }

    /* User Message (Right) */
    .msg-right {
        align-items: flex-end;
    }

    .msg-right .bubble {
        background: linear-gradient(135deg, rgba(153, 69, 255, 0.2), rgba(153, 69, 255, 0.4));
        border: 1px solid rgba(153, 69, 255, 0.4);
        color: white;
        border-radius: 15px 15px 0 15px;
    }

    .bubble {
        max-width: 75%;
        padding: 12px 18px;
        font-size: 0.95rem;
        position: relative;
        line-height: 1.5;
    }

    .user-label {
        font-size: 0.75rem;
        color: rgba(255, 255, 255, 0.5);
        margin-bottom: 5px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Footer & Input */
    .chat-footer-custom {
        padding: 20px;
        background: rgba(0, 0, 0, 0.2);
        border-top: 1px solid rgba(153, 69, 255, 0.2);
    }

    .chat-input-group {
        display: flex;
        gap: 10px;
        background: rgba(255, 255, 255, 0.05);
        padding: 8px;
        border-radius: 12px;
        border: 1px solid rgba(153, 69, 255, 0.3);
    }

    .chat-input-group input {
        background: transparent;
        border: none;
        color: white;
        flex: 1;
        padding: 10px 15px;
        outline: none;
    }

    /* Custom Scrollbar */
    .chat-body-custom::-webkit-scrollbar {
        width: 5px;
    }

    .chat-body-custom::-webkit-scrollbar-thumb {
        background: rgba(153, 69, 255, 0.3);
        border-radius: 10px;
    }
   .btn-back {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        color: rgba(255, 255, 255, 0.7) !important;
        padding: 6px 15px;
        border-radius: 8px;
        font-size: 0.8rem;
        font-weight: 600;
        text-decoration: none;
        transition: 0.3s;
        display: flex;
        align-items: center;
    }
</style>

<div style="padding-top: 140px; padding-bottom: 80px; min-height: 100vh; color: white;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">

                <?php $userId = Helpers::user_id(); ?>

                <div class="chat-card" style="max-width: 800px;margin:auto">
                    <div class="chat-header-custom">
                        <div>
                            <h5 class="m-0" style="font-weight: 700; color: white;">Chat</h5>
                        </div>
                        <div>
                            <a href="<?= base_url('support'); ?>" class="btn-back">
                                <i class="fas fa-arrow-left mr-1"></i> Back
                            </a>
                        </div>
                    </div>

                    <div class="chat-body-custom">
                        <?php if ($data) : ?>
                            <?php foreach ($data as $chat) : ?>

                                <?php if ($chat['user_id'] != $userId || $chat['status'] == 2) : ?>
                                    <div class="message-wrapper msg-left">
                                        <span class="user-label">Support Team</span>
                                        <div class="bubble">
                                            <?= $chat['message']; ?>
                                        </div>
                                    </div>
                                <?php else : ?>
                                    <div class="message-wrapper msg-right">
                                        <span class="user-label"><?= Helpers::getUserObj()['username']; ?></span>
                                        <div class="bubble">
                                            <?= $chat['message']; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <div class="chat-footer-custom">
                        <?php if ($data[0]['status'] != 1) : ?>
                            <form action="<?= Helpers::generateLink('send_reply'); ?>" method="post">
                                <input type="hidden" name="token" value="<?= ($data[0]['ticket_no']) ?: ''; ?>">
                                <input type="hidden" name="subject" value="<?= ($data[0]['subject']) ?: ''; ?>">

                                <div class="chat-input-group">
                                    <input type="text" name="message" placeholder="Type your reply here..." required maxlength="500">
                                    <button type="submit" class="btn btn-primary" style="border-radius: 8px; padding: 8px 25px;">
                                        Send
                                    </button>
                                </div>
                            </form>
                        <?php else : ?>
                            <div class="text-center p-2" style="background: rgba(20, 241, 149, 0.1); border-radius: 10px; border: 1px solid rgba(20, 241, 149, 0.3);">
                                <span style="color: #14F195; font-size: 0.9rem; font-weight: 600;">
                                    <i class="fas fa-check-circle mr-2"></i> This ticket has been marked as Resolved.
                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>