<link rel="stylesheet" href="<?= base_url() ?>website/css/support.css">
<style>
    @media screen and (max-width:767px) {
        .dataTables_filter {
            display: none !important;
        }

        .send {
            width: auto !important;
            padding: 8px 8px !important;
            font-size: 11px !important;
        }

        .card {
            padding: 1rem !important;
        }

        .title {
            font-size: 15px !important;
        }
    }
</style>
<div style="padding-top: 140px; padding-bottom: 80px; min-height: 100vh; color: white;">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="header mb-4">
                        <h3 class="title" style="font-weight: 700; margin: 0;">Support History</h3>
                        <button type="button" onclick="openSupportModal()" class="btn btn-primary send" style="padding: 10px 25px;">
                            <i class="fas fa-plus mr-2"></i> Send Message
                        </button>
                    </div>
                    <div class="text-center" style="margin-bottom: 30px;">
                        <?php if ($this->session->flashdata()) {
                            echo Helpers::showFlash($this->session->flashdata("response"));
                        } ?>
                    </div>
                    <div class="card-wrapper" style="max-height: 600px;overflow-y:scroll;grid-template-columns: <?= $data ?  'repeat(auto-fill, minmax(320px, 1fr))' : "unset" ?>;">
                        <?php if (!empty($data)) : ?>
                            <?php foreach ($data as $key => $complaint) :
                                $date = date('d-M-Y', strtotime($complaint["created_at"]));
                            ?>
                                <div class="info-card">
                                    <div class="card-row header-row">
                                        <span class="label">Ticket Ref</span>
                                        <span class="value ticket-id">#<?= $key + 1; ?></span>
                                    </div>

                                    <hr class="divider">

                                    <div class="card-row">
                                        <span class="label">Date</span>
                                        <span class="value"><?= $date; ?></span>
                                    </div>

                                    <div class="card-row">
                                        <span class="label">Subject</span>
                                        <span class="value subject-text"><?= htmlspecialchars($complaint["subject"]); ?></span>
                                    </div>

                                    <div class="card-row">
                                        <span class="label">Status</span>
                                        <span class="value">
                                            <?php if ($complaint["status"] == 1) : ?>
                                                <span class="status-badge resolved">Resolved</span>
                                            <?php else : ?>
                                                <span class="status-badge pending">Pending</span>
                                            <?php endif; ?>
                                        </span>
                                    </div>

                                    <div class="card-footer">
                                        <a href="<?= base_url('single_complaint'); ?>?ticket_no=<?= $complaint['ticket_no']; ?>" style="width: 100%;" class="btn btn-primary">
                                            View Chat
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <div class="empty-state" style="text-align: center;margin: 30px 0px;">
                                <div class="empty-icon">
                                    <svg viewBox="0 0 24 24" width="64" height="64" stroke="currentColor" stroke-width="1" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
                                        <line x1="9" y1="10" x2="15" y2="10"></line>
                                        <line x1="9" y1="14" x2="13" y2="14"></line>
                                    </svg>
                                </div>
                                <h2>No Complaints Yet</h2>
                                <p>It looks like everything is running smoothly. When you raise a ticket, it will appear here.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="supportModal" class="custom-modal">
    <div class="modal-content">
        <span class="close-modal" onclick="closeSupportModal()">&times;</span>

        <h3 style="font-weight: 700; margin-bottom: 10px;">Create Support Ticket</h3>


        <form method="post" action="<?= base_url('create_support') ?>">
            <div class="row">
                <div class="mb-3 col-md-12">
                    <label class="form-label">Subject</label>
                    <input type="text" class="form-control-custom text-left" style="letter-spacing: normal; font-size: 1rem;" placeholder="Enter subject" name="subject" required>
                </div>

                <div class="mb-3 col-md-12">
                    <label class="form-label">Message</label>
                    <textarea name="message" class="form-control-custom text-left" style="letter-spacing: normal; font-size: 1rem; min-height: 100px; padding: 15px;" placeholder="Describe your issue..." required></textarea>
                </div>
            </div>

            <div style="margin-top: 20px;">
                <button type="submit" class="btn btn-primary w-100" style="width: 100%; max-width: unset!important;">
                    Send Message
                </button>
            </div>
        </form>
    </div>
</div>
<!-- jQuery -->
<style>
    /* Input customization specifically for the support form */
    .modal-content .form-control-custom.text-left {
        text-align: left !important;
        letter-spacing: 0px !important;
    }

    /* Textarea behavior */
    textarea.form-control-custom {
        resize: none;
    }
</style>

<script>
    function openSupportModal() {
        document.getElementById('supportModal').style.display = 'block';
        document.body.style.overflow = 'hidden';
    }

    function closeSupportModal() {
        document.getElementById('supportModal').style.display = 'none';
        document.body.style.overflow = 'auto';
    }

    // Close on outside click
    window.onclick = function(event) {
        let modal = document.getElementById('supportModal');
        if (event.target == modal) {
            closeSupportModal();
        }
    }
</script>