<?php

class Admin extends ci_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model(array('Adm', 'users', 'Members'));
        $this->username = $this->session->userdata('adminlogin');
        if (!$this->username) {
            redirect('master');
        }
    }
    public function settings()
    {
        if ($this->input->post()) {
            $mp = $this->input->post("master_password");
            $update = $this->Adm->update_settings($mp);
            if ($update) {
                $flash = Helpers::flash('success', 'Your Password Updated Successfully');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/settings");
            } else {

                $flash = Helpers::flash('danger', 'Something Went Wrong !');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/settings");
            }
        }
        $settings = $this->Adm->get_settings();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/settings", "data" => $settings]);
    }
    public function dashboard()
    {
        $data["newusers"] = $this->Adm->get_newuser(5);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/dashboard", "data" => $data]);
    }

    public function all_users()
    {

        $users = $this->Adm->get_all_users();
        $data['users'] = $users;
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/all_users", "data" => $data]);
    }
    public function all_users_old()
    {
        $this->load->library('pagination');

        $config = array();
        $config['base_url'] = base_url() . 'admin/all_users';
        $config["total_rows"] = count($this->Adm->get_all_users());
        $config["per_page"] = 20;
        $config["uri_segment"] = 3;
        $config['full_tag_open'] = "<div class='pagination'>";

        $config['full_tag_close'] = "</div>";



        $config['use_page_numbers'] = TRUE;

        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = ' Previous';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        // $config['attributes'] = array('class' => 'pagination');


        $this->pagination->initialize($config);
        $segment = Helpers::is_localhost() ? $this->uri->segment(3) : $this->uri->segment(3);
        $page = $segment ? $segment : 0;

        $data["links"] = $this->pagination->create_links();
        $users = $this->Adm->get_all_users($config["per_page"], $page);
        $data['users'] = $users;
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/all_users", "data" => $data]);
    }
    public function edit_user()
    {
        $id = $this->uri->segment(3) ? $this->uri->segment(3) : $this->input->post("id");
        $user = array();
        $this->load->model('Members');

        $user["single"] = $this->Adm->single_user($id);
        $user["team"] = $this->Members->getMyTeam($id);
        if ($this->input->post()) {
            $data["full_name"] = $this->input->post("full_name");
            $data["email"] = $this->input->post("email");
            $data["phone_number"] = $this->input->post("phone_number");
            // $data["status"] = $this->input->post("status");
            // echo $data["status"];
            $isUpdated = $this->users->updateUser($id, $data);
            if ($isUpdated) {
                $this->session->set_flashdata('response', 'User saved successfully!');
                $user = $this->Adm->single_user($id);
                redirect(base_url() . 'Admin/all_users');
            } else {
                $this->session->set_flashdata('response', 'Something went wrong!');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_user", "data" => $user]);
    }

    public function deposit_request()
    {
        $requests = $this->Adm->get_all_fund_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/deposit_request", "data" => $requests]);
    }
    public function exchange_request()
    {
        $requests = $this->Adm->get_all_exchange_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/exchange_request", "data" => $requests]);
    }
    public function wallet_details()
    {
        if ($this->input->post()) {
            $data["usdt_address"] = $this->input->post("usdt");
            $data["usdc_address"] = $this->input->post("usdc");
            $data["busd_address"] = $this->input->post("busd");

            $data["btc_address"] = $this->input->post("btc");
            $data["eth_address"] = $this->input->post("eth");
            $data["ripple_address"] = $this->input->post("ripple");
            $data["doge_address"] = $this->input->post("doge");
            $data["shiba_address"] = $this->input->post("shiba");
            $data["bnb_address"] = $this->input->post("bnb");
            $fileName = '';
            if (!empty($_FILES['image_url']['name'])) {
                $uploadPath = 'uploads/files/qr/' .  $this->username["id"];
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777);
                }
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png';

                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                // Upload file to server
                if ($this->upload->do_upload('image_url')) {
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                }
            }
            $data['usdt_qr'] = $fileName ? $fileName : $this->username["usdt_qr"];


            $id = $this->username["id"];
            $resp = $this->Adm->update_admin($id, $data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/wallet_details");
            }
        }
        $id = $this->username["id"];
        $requests = $this->Adm->get_admin_details($id);

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/wallet_details", "data" => $requests]);
    }

    public function disapprove_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 2;
            // $data["marked"] = 1;

            $resp = $this->Adm->update_status($id, $data);

            if ($resp) {

                $flash = Helpers::flash('danger', 'Request has been rejected.');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/deposit_request");
            } else {
                echo "failed";
            }
        }
    }
    public function approve_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;

            $resp = $this->Adm->update_status($id, $data);
            $fundRow = $this->Adm->get_row_by_id($id);
            if ($resp) {
                $userId = $fundRow["user_id"];
                $wallet = array();
                $wallet["user_id"] = $userId;
                // $walletInUSD = Coinpayments::get_btc_dollars($fundRow['wallet_type'], $fundRow['amount']);
                $walletInUSD = $fundRow['amount'];
                $wallet['wallet_amount'] = $walletInUSD;
                $wallet['updated_at'] = date('Y-m-d H:i:s');
                $res = $this->Adm->add_wallet_amount($userId, $wallet);



                $flash = Helpers::flash('success', 'Your request has been updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/deposit_request");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_exchange()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 2;
            // $data["marked"] = 1;

            $resp = $this->Adm->update_exchange_status($id, $data);

            if ($resp) {

                $flash = Helpers::flash('danger', 'Request has been rejected.');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/exchange_request");
            } else {
                echo "failed";
            }
        }
    }
    public function approve_exchange()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 1;
            // $data["marked"] = 1;

            $resp = $this->Adm->update_exchange_status($id, $data);
            $fundRow = $this->Adm->get_row_exchange_by_id($id);
            if ($resp) {
                $userId = $fundRow["user_id"];
                $wallet = array();
                $wallet["user_id"] = $userId;
                // $walletInUSD = Coinpayments::get_btc_dollars($fundRow['wallet_type'], $fundRow['amount']);
                $walletInUSD = $fundRow['amount'];
                $wallet['wallet_amount'] = $walletInUSD;
                $wallet['updated_at'] = date('Y-m-d H:i:s');
                // $res = $this->Adm->add_wallet_amount($userId, $wallet);



                $flash = Helpers::flash('success', 'Your request has been updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/exchange_request");
            } else {
                echo "failed";
            }
        }
    }



    public function user_status()
    {
        $this->load->library('pagination');

        $config = array();
        $config['base_url'] = base_url() . 'admin/user_status';
        $config["total_rows"] = count($this->Adm->get_all_users());
        $config["per_page"] = 20;
        $config["uri_segment"] = 3;
        $config['full_tag_open'] = "<div class='pagination'>";

        $config['full_tag_close'] = "</div>";



        $config['use_page_numbers'] = TRUE;

        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = ' Previous';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        // $config['attributes'] = array('class' => 'pagination');


        $this->pagination->initialize($config);
        $segment = $this->uri->segment(3);
        $page = $segment ? $segment : 0;

        $data["links"] = $this->pagination->create_links();
        $users = $this->Adm->get_all_users($config["per_page"], $page);
        $data['users'] = $users;
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/user_status", "data" => $data]);
    }



    public function edit_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $data['first_name'] = $this->input->post("full_name");
            $data["status"] = $this->input->post("status");
            $update = $this->Adm->updateuser($id, $data);
            if ($update) {
                $flash = Helpers::flash('success', 'User Update Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/user_status');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/user_status');
            }
        }
        $id = $this->input->get("id");
        $user = Helpers::userdetails($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_status", "data" => $user]);
    }

    public function edit_users()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $data["first_name"] = $this->input->post("first_name");
            $data["phone"] = $this->input->post("phone");
            $update = $this->Adm->updateuser($id, $data);
            if ($update) {
                $flash = Helpers::flash('success', 'User Update Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/all_users');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/all_users');
            }
        }
        $id = $this->input->get("id");
        $user = Helpers::userdetails($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_user", "data" => $user]);
    }

    public function support()
    {
        $this->load->helper('text');
        $getAllSupport = $this->Adm->get_support_messages();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/complaints", "data" => $getAllSupport]);
    }

    public function admin_message()
    {
        $this->load->helper('text');
        $getAllSupport = $this->Adm->get_support_admin_messages();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/admin_message", "data" => $getAllSupport]);
    }
    public function support_resolved()
    {
        $this->load->helper('text');
        $getAllSupport = $this->Adm->get_support_messages_resolved();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/support_resolved", "data" => $getAllSupport]);
    }
    public function single_complaint()
    {
        $id = $this->uri->segment(3);
        $path = $this->uri->segment(4);
        $this->load->model('adm');
        $complaints = $this->Adm->get_support_message_by_ticket($id);
        if ($complaints) {
            $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/single_complain", "data" => $complaints, 'path' => $path]);
        }
    }
    public function send_reply()
    {
        $data["user_id"] = 1;
        $data["to_id"] = $this->input->post('user_id');
        $data["subject"] = $this->input->post('subject');
        $path = $this->input->post('path');
        $message = $this->input->post('message');
        $data["message"] = nl2br($message);

        $token = $this->input->post('token');
        $data["ticket_no"] = $token;

        $data["created_at"] = Helpers::date();
        $this->load->model("Members");
        $res = $this->Members->add_support_ticket($data);

        $userObj = Helpers::getUserObj($data["to_id"]);
        $emailTitle = 'support ticket ' . '' . $token;
        Helpers::sendEmail($emailTitle, $userObj["email"], $message);
        return redirect("admin/single_complaint/" . $token . '/' . $path);
    }
    public function withdraw_requests()
    {
        $this->Adm->update_admin(1, ["notify" => 0]);
        $data = $this->Adm->get_all_withdrawal();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_fund_requests", "data" => $data]);
    }
    public function approve_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $row =   $this->Adm->get_withdraw_single_request($id);

            $data["status"] = 1;

            $resp = $this->Adm->update_withdraw($id, $data);
            if ($resp) {
                $this->Members->substract_wallet_amount($row['user_id'], $row['amount']);
                $flash = Helpers::flash('success', 'Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_requests");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_requests");
            }
        }
    }
    public function disapprove_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $row =   $this->Adm->get_withdraw_single_request($id);

            $data["status"] = 2;

            $resp = $this->Adm->update_withdraw($id, $data);
            if ($resp) {
                // $wallet['user_id'] = $row['user_id'];
                // $wallet['wallet_amount'] = $row['amount'];
                // $wallet['updated_at'] = date("Y-m-d H:i:s");
                // $this->Members->add_wallet_amount($wallet['user_id'], $wallet);
                $flash = Helpers::flash('danger', 'Withdrawal Rejected.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_requests");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_requests");
            }
        }
    }
    public function package_status()
    {
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/package_status"]);
    }
    public function leverage_amount()
    {
        $data = $this->Adm->usersleverage();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/leverage_amount", "data" => $data]);
    }
    function edit_withdraw()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");

            $fileName = '';
            if (!empty($_FILES['image_url']['name'])) {
                $uploadPath = 'uploads/files/withdrawslip/' . $id;
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777);
                }
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|gif';

                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                // Upload file to server
                if ($this->upload->do_upload('image_url')) {
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                }
            }
            $data['slip'] = $fileName;
            $res = $this->Adm->updateslip($id, $data);
            if ($res) {
                $flash = Helpers::flash('success', 'Slip Updated Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/cc_requests');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/cc_requests');
            }
        }
        $id = $this->input->get("id");
        $withdrawal = $this->Adm->get_single_withdrawal($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_withdraw", "data" => $withdrawal]);
    }
    function manage_blogs()
    {

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/manage_blogs"]);
    }
    public function approve_post()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_post_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_post($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_blogs");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_post()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_post_details($id);
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;
            $resp = $this->Adm->update_post($id, $data);
            if ($resp) {

                $flash = Helpers::flash('danger', 'Post Rejected.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_blogs");
            } else {
                echo "failed";
            }
        }
    }
    function manage_loans()
    {

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/manage_loans"]);
    }
    public function approve_loan()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_loan_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_loan($id, $data);
            if ($resp) {
                $wallet["amount"] = $getdetails["amount"];
                $wallet["user_id"] = $getdetails["user_id"];
                $this->load->model("Members");
                $this->Members->add_earning_amount($getdetails["user_id"], $wallet);
                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_loans");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_loan()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_loan_details($id);
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;
            $resp = $this->Adm->update_loan($id, $data);
            if ($resp) {

                $this->Members->add_earning_amount($getdetails["user_id"], $wallet);
                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_loans");
            } else {
                echo "failed";
            }
        }
    }
    public function add_funds()
    {
        if ($this->input->post()) {
            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/add_funds');
            }

            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["wallet_amount"] = $amount;
            $data["updated_at"] = date('Y-m-d');
            $update = $this->Adm->add_wallet_amount($userid, $data);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deposit";
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Transferred");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/add_funds');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/add_funds"]);
    }
    public function deduct_funds()
    {
        if ($this->input->post()) {

            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }
            $getwallet =  $this->Members->get_user_wallet($getuser['id']);
            $checkwalletBalance = $getwallet['wallet_amount'];
            if (($checkwalletBalance) < $amount) {
                $flash = Helpers::flash('danger', "Balance is $checkwalletBalance ");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }


            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["wallet_amount"] = $amount;
            $data["updated_at"] = date('Y-m-d');
            $update = $this->Adm->substract_wallet_amount($userid, $amount);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deduct";
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Deducted");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/deduct_funds"]);
    }

    public function change_password()
    {
        if ($this->input->post()) {
            $data["password"] = sha1($this->input->post("password"));



            $id = $this->username["id"];
            $resp = $this->Adm->update_admin($id, $data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Password changed Successfully !!!');
            } else {
                $flash = Helpers::flash('danger', 'Something Went Wrong!!!');
            }
            $this->session->set_flashdata('response', $flash);
        }


        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/change_password"]);
    }

    public function direct_commission()
    {
        if ($this->input->post()) {
            $data["direct_commission"] = $this->input->post("direct_commission");




            $resp = $this->Adm->update_setting_direct($data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Updated Successfully !!!');
            } else {
                $flash = Helpers::flash('danger', 'Something Went Wrong!!!');
            }
            $this->session->set_flashdata('response', $flash);
        }

        $settings = $this->Adm->get_settings();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/direct_commission", "data" => $settings]);
    }

    function deposit()
    {
        if ($this->input->post()) {
            $this->form_validation->set_rules('username', 'Username', 'required');
            $this->form_validation->set_rules('amount', 'amount', 'required');

            if ($this->form_validation->run() == FALSE) {
                //$this->load->view("layouts/common", ["template"=>"pages/register"]); 
            } else {
                $uname = $this->input->post("username");
                $walletInUSD = $this->input->post("amount");

                $this->load->model(array('Users', 'Members'));
                $getUser = $this->Users->getUserByUsername($uname);
                if (!$getUser) {
                    $flash = Helpers::flash('danger', 'No user found with this username');
                } else {

                    $wallet = array();
                    $wallet['user_id'] = $getUser['id'];
                    $wallet['wallet_amount'] = $walletInUSD;
                    $wallet['updated_at'] = Helpers::date();
                    $result = $this->Members->add_wallet_amount($getUser['id'], $wallet);
                    if ($result) {
                        $add["user_id"] = $getUser['id'];
                        $add["amount"] = $walletInUSD;
                        $add["operation"] = 1;
                        $add["date"] = Helpers::date();
                        $this->adm->addAdminTrasnferEntry($add);

                        $user_earning =  MemberHelper::user_wallet($add["user_id"]);
                        $flash = Helpers::flash('success', "Amount added successfully. Total Amount is $user_earning ");
                        // redirect("admin/deposit");
                    } else {
                        $flash = Helpers::flash('danger', 'Something went wrong');
                    }
                }
                $this->session->set_flashdata('response', $flash);
            }
        }
        $data = $this->adm->getTransferEntries(1);
        $this->load->view("admin/layouts/menu", ["template" => "admin/pages/deposit", "data" => $data]);
    }

    public function create_support()
    {

        if ($this->input->post()) {

            $data = array();
            $uname =    $this->input->post('username');
            $user = $this->Users->getuserbyuname($uname);
            if (empty($user)) {
                $flash = Helpers::flash('danger', 'User Not Found');

                $this->session->set_flashdata('response', $flash);

                return redirect('admin/create_support');
            }


            $data["user_id"] = $user["id"];

            $data["to_id"] = 1;

            $data["subject"] = $this->input->post('subject');

            $message = $this->input->post('message');

            $data["message"] = $message;

            $data["status"] = 2;



            $token = Helpers::generateUniqueRefId(10) . '_' . $user["id"];

            $data["ticket_no"] = $token;

            $data["created_at"] = Helpers::date();

            $res = $this->Members->add_support_ticket($data);
            if ($res) {


                $mailView = $this->load->view("emails/support-user", array("user" => $user, "data" => $data), true);
                Helpers::sendEmail("Support", $user["email"], $mailView);

                $flash = Helpers::flash('success', 'Message sent to User');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/create_support');
            }
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/create_support"]);
    }

    function ticket_status()
    {
        $id = $this->input->post('ticket_id');
        $status = $this->input->post('status');
        $token = $this->input->post('ticket_no');
        $path = $this->input->post('path');
        $data["status"] = 1;
        $update = $this->Adm->update_chat_status($token, $data);
        return redirect("admin/" . $path);
    }

    public function topupBalance()
    {
        $data = $this->Adm->getAllTopupBalance();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/topupbalance", "data" => $data]);
    }

    public function delete_user($id)
    {
        $this->load->model('Adm');

        // Delete the user by ID
        $isDeleted = $this->Adm->delete_user($id);

        if ($isDeleted) {
            $this->session->set_flashdata('response', 'User deleted successfully!');
        } else {
            $this->session->set_flashdata('response', 'Failed to delete user.');
        }

        redirect(base_url('Admin/all_users'));
    }
    public function bulk_delete()
    {
        $selected_users = $this->input->post('user_ids'); // Get selected user IDs

        if (!empty($selected_users)) {
            $this->Adm->delete_users($selected_users);
            $this->session->set_flashdata('response', 'Selected users deleted successfully.');
        } else {
            $this->session->set_flashdata('response', 'No users selected.');
        }
        redirect('Admin/all_users');
    }

    public function new_email($id)
    {
        $this->load->model('Adm');
        $user = $this->Adm->single_user($id);
        $data["status"] = 1;
        $update = $this->Adm->updateuser($user["id"], $data);
        $mailView = $this->load->view("emails/admin_register", array("user" => $user), true);
        // $this->load->library('email');
        // $this->email->from('donotreply@SOLlender.com', 'Solenders');
        // $this->email->to($user["email"]);
        // $this->email->subject('Don’t Miss Out: Start Staking Your SOL!');
        // $message = $this->load->view('emails/admin_register', $user, TRUE);
        // $this->email->set_mailtype('html');
        // $this->email->message($message);
        // $this->email->send();


        Helpers::SendEmail("Do not Miss Out: Start Lending Your SOL Today!", $user["email"], $mailView);
        $this->session->set_flashdata('response', 'Email sent and account activated');


        redirect(base_url('Admin/all_users'));
    }
    public function welcome_email($id)
    {
        $this->load->model('Adm');
        $user = $this->Adm->single_user($id);
        $data["status"] = 0;
        $update = $this->Adm->updateuser($user["id"], $data);
        $mailView = $this->load->view("emails/welcome-email", array("user" => $user), true);
        $this->load->library('email');
        $this->email->from('noreply@Solenders.com', 'Solenders');
        $this->email->to($user["email"]);
        $this->email->subject('Don’t Miss Out: Start Landing Your SOL Today!');
        $message = $this->load->view('emails/activated', $user, TRUE);
        $this->email->set_mailtype('html');
        $this->email->message($message);
        $this->email->send();


        Helpers::SendEmail("Welcome to Solenders", $user["email"], $mailView);
        $this->session->set_flashdata('response', 'Email sent and account activated');


        redirect(base_url('Admin/all_users'));
    }

    function logout()
    {
        $this->session->sess_destroy();
        redirect('master');
    }
}
