<?php
defined('BASEPATH') or exit('No direct script access allowed');


class Users extends CI_Model
{

	public function login_user($data, $admin = false)
	{
		// $data['master'] = '';
		if ($admin) {
			$this->db->where("role", 1);
			$this->db->where('username', $data["username"]);
		} else {
			$this->db->where("role", 2);
			$this->db->where('email', $data["email"]);
		}


		$this->db->where('password', sha1($data["password"]));

		$this->db->where("status", 1);
		$query = $this->db->get('users');
		return $query->row_array();
	}
	public function getAdminAccount()
	{
		$this->db->where('role', 1);
		$query = $this->db->get('users');
		return $query->row_array();
	}

	public function register_user($data)
	{
		if ($this->db->insert('users', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('users', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function contact_user($data)
	{
		if ($this->db->insert('contact', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('contact', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function add_fund_deposit($data)
	{
		if ($this->db->insert('topup_requests', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('topup_requests', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function accepted_request($user_id)
	{
		$this->db->where('user_id', $user_id);
		$data = $this->db->get("topup_requests")->result_array();
		return $data;
	}
	public function add_exchange_deposit($data)
	{
		if ($this->db->insert('exchange_requests', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('exchange_requests', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function accepted_exchange_request($user_id)
	{
		$this->db->where('user_id', $user_id);
		$data = $this->db->get("exchange_requests")->result_array();
		return $data;
	}

	public function withdrawal_request($data)
	{
		if ($this->db->insert('withdrawal_request', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('withdrawal_request', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	public function get_withdrawal($user_id)
	{
		$this->db->where('user_id', $user_id);
		$data = $this->db->get("withdrawal_request")->result_array();
		return $data;
	}

	public function getUserByRefCode($code)
	{
		$user = $this->db->get_where('users', array('referral_id' => $code))->row_array();
		return $user ? $user : false;
	}

	public function getUserByCondition($condition)
	{
		$user = $this->db->get_where('users', $condition)->result_array();
		return $user ? $user : false;
	}

	public function getUserById($id)
	{
		$user = $this->db->get_where('users', array('id' => $id))->row_array();
		return $user ? $user : false;
	}
	public function getuserbyuname($username)
	{
		$user = $this->db->get_where('users', array('username' => $username))->row_array();
		return $user ? $user : false;
	}
	public function getgenexEarningUserById($id)
	{
		$user = $this->db->get_where('genex_earnings', array('user_id' => $id))->row_array();
		return $user ? $user : false;
	}

	public function getPackageById($id)
	{
		$user = $this->db->get_where('products', array('id' => $id))->row_array();
		return $user ? $user : false;
	}

	public function getUserByEmail($email)
	{
		$user = $this->db->get_where('users', array('email' => $email))->row_array();
		return $user ? $user : false;
	}

	public function getUserByUsername($uname)
	{
		$user = $this->db->get_where('users', array('username' => $uname))->row_array();
		return $user ? $user : false;
	}
	public function getUserByToken($token)
	{
		$user = $this->db->get_where('users', array('reset_token' => $token))->row_array();
		return $user ? $user : false;
	}

	public function getUniqueUsername($slug)
	{
		$this->db->select('username');
		$this->db->where('username', $slug);
		$query = $this->db->get('users');
		$result = $query->row_array();
		return $result ? $result : false;
	}



	public function updateUser($userId, $data)
	{
		$this->db->where('id', $userId);
		$this->db->update('users', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}



	public function getAllUsers()
	{
		$this->db->where('role', 2);
		$query = $this->db->get('users');
		return $query->result_array();
	}

	public function activateUserByKey($key)
	{
		$user = $this->db->get_where("users", array("register_token" => $key))->row_array();
		if ($user) {
			$this->db->where('id', $user["id"]);
			$data = array();
			$data["status"] = 1;
			$this->db->update('users', $data);
			if ($this->db->affected_rows()) {
				return $user;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	function sum_growth()
	{
		$q =	$this->db->query("SELECT
			distinct(user_id), sum(amount)
		FROM
		daily_growth GROUP BY user_id");

		return $q->result_array();
	}


	public function updateUserStatus($userId, $data)
	{
		$this->db->where('id', $userId);
		return $this->db->update('users', $data); // Assuming 'users' is your user table
	}
}
