<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=0,minimal-ui">
  <title>SolanaStaker - Admin Login</title>
  <meta content="Admin Dashboard" name="description">
  <meta content="Themesbrand" name="author">
  <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.png">
  <link href="<?= base_url() ?>admin/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
  <link href="<?= base_url() ?>admin/assets/css/metismenu.min.css" rel="stylesheet" type="text/css">
  <link href="<?= base_url() ?>admin/assets/css/icons.css" rel="stylesheet" type="text/css">
  <link href="<?= base_url() ?>admin/assets/css/style.css" rel="stylesheet" type="text/css">
</head>
<style>
  .logo-text {
    font-size: 1.5rem;
    font-weight: 700;
    background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
  }

  .logo {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    justify-content: center;
    text-decoration: none;
    transition: transform 0.3s ease
  }

  .logo-icon {
    width: 40px;
    height: 40px;
    border-radius: 0.5rem;
    background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
  }
</style>

<body>
  <!-- Background -->
  <div class="account-pages">
  </div>
  <div class="container">
    <!-- Begin page -->
    <div class="row">
      <div class="col-lg-6 offset-lg-3 mt-4">
        <div class="wrapper-page">
          <div class="card">
            <div class="card-body">
              <h3 class="text-center m-0">
                <a href="<?= base_url() ?>" class="logo">
                  <div class="logo-icon">
                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M5.5 20.5L10 16L5.5 11.5L7 10L13 16L7 22L5.5 20.5Z" fill="url(#gradient1)" />
                      <path d="M14 11H26V13H14V11Z" fill="url(#gradient2)" />
                      <path d="M14 19H26V21H14V19Z" fill="url(#gradient3)" />
                      <defs>
                        <linearGradient id="gradient1" x1="5.5" y1="10" x2="13" y2="22" gradientUnits="userSpaceOnUse">
                          <stop stopColor="#9945FF" />
                          <stop offset="1" stopColor="#14F195" />
                        </linearGradient>
                        <linearGradient id="gradient2" x1="14" y1="11" x2="26" y2="13" gradientUnits="userSpaceOnUse">
                          <stop stopColor="#9945FF" />
                          <stop offset="1" stopColor="#00D4FF" />
                        </linearGradient>
                        <linearGradient id="gradient3" x1="14" y1="19" x2="26" y2="21" gradientUnits="userSpaceOnUse">
                          <stop stopColor="#14F195" />
                          <stop offset="1" stopColor="#00D4FF" />
                        </linearGradient>
                      </defs>
                    </svg>
                  </div>
                  <span class="logo-text">SolStaker</span>
                </a>
              </h3>
              <div class="p-3">
                <h4 class="text-muted font-18 m-b-5 text-center">Welcome Back !</h4>
                <p class="text-muted text-center">Please login to your account.</p>

                <?php if ($this->session->flashdata()) {
                  echo Helpers::showFlash($this->session->flashdata("response"));
                } ?>

                <form class="form-horizontal m-t-30" action="#" method="post">
                  <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" class="form-control" name="username" placeholder="Enter username">
                  </div>
                  <div class="form-group">
                    <label for="userpassword">Password</label>
                    <input type="password" class="form-control" name="password" placeholder="Enter password">
                  </div>
                  <div class="form-group row m-t-20">
                    <div class="col-6">

                    </div>
                    <div class="col-6 text-right"><button class="btn btn-success w-md waves-effect waves-light" type="submit">Login Now</button></div>
                  </div>

                </form>
              </div>
            </div>
          </div>

        </div>
      </div>

    </div>
  </div>
  <!-- END wrapper -->
  <!-- jQuery  -->
  <script src="<?= base_url() ?>admin/assets/js/jquery.min.js"></script>
  <script src="<?= base_url() ?>admin/assets/js/bootstrap.bundle.min.js">

  </script>
  <script src="<?= base_url() ?>admin/assets/js/metisMenu.min.js">

  </script>
  <script src="<?= base_url() ?>admin/assets/js/jquery.slimscroll.js">

  </script>
  <script src="<?= base_url() ?>admin/assets/js/waves.min.js"></script>
  <script src="../plugins/jquery-sparkline/jquery.sparkline.min.js">

  </script><!-- App js -->
  <script src="<?= base_url() ?>admin/assets/js/app.js"></script>
</body>

</html>