<!-- Main Content -->
<style>
    @media (max-width:1075px) {
        .divblock {
            display: block !important;
        }

        .divblock img {
            height: 400px !important;
        }

        .card-2 {
            margin-top: 20px !important;
        }
    }
</style>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.js"></script>
<div style="padding-top: 140px; padding-bottom: 80px; min-height: 100vh;">
    <div class="container">
        <!-- Header -->
        <div class="text-center"> <?php if ($this->session->flashdata()) {
                                        echo Helpers::showFlash($this->session->flashdata("response"));
                                    } ?></div>
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 3rem; flex-wrap: wrap; gap: 1rem;">
            <div>
                <h1 style="font-size: 2.5rem; font-weight: 700; margin-bottom: 0.5rem;">Dashboard</h1>
                <p style="color: rgba(255,255,255,0.7); font-size: 1.25rem;">Track your staking performance</p>
            </div>
            <div style="display: flex; gap: 1rem;">
                <a href="<?= base_url() ?>deposit" class="btn btn-primary">Deposit</a>
                <a href="<?= base_url() ?>withdrawal" class="btn btn-secondary">Withdraw</a>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="grid grid-4" style="margin-bottom: 3rem;">
            <div class="card" style="position: relative; overflow: hidden;">
                <div style="position: absolute; top: 0; right: 0; width: 128px; height: 128px; background: linear-gradient(135deg, var(--solana-purple), var(--solana-cyan)); opacity: 0.1; filter: blur(40px); border-radius: 50%;"></div>
                <div style="position: relative;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 1rem;">
                        <div>
                            <p style="color: rgba(255,255,255,0.6); font-size: 0.875rem; margin-bottom: 0.5rem;">Total Earned</p>
                            <h3 style="font-size: 2rem; font-weight: 700;"><?= MemberHelper::user_wallet(); ?> SOL</h3>
                        </div>
                        <div style="padding: 0.75rem; background: rgba(255,255,255,0.05); border-radius: 0.75rem; height: fit-content;">
                            💰
                        </div>
                    </div>
                    <div style="color: #14F195; font-size: 0.875rem; font-weight: 600;">+2.5%</div>
                </div>
            </div>

            <div class="card" style="position: relative; overflow: hidden;">
                <div style="position: absolute; top: 0; right: 0; width: 128px; height: 128px; background: linear-gradient(135deg, var(--solana-purple), var(--solana-cyan)); opacity: 0.1; filter: blur(40px); border-radius: 50%;"></div>
                <div style="position: relative;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 1rem;">
                        <div>
                            <p style="color: rgba(255,255,255,0.6); font-size: 0.875rem; margin-bottom: 0.5rem;">Monthly Earnings</p>
                            <h3 style="font-size: 2rem; font-weight: 700;"><?php $bal = MemberHelper::user_wallet();
                                                                            $earnings = $bal * 0.10;
                                                                            echo $earnings;
                                                                            ?> SOL</h3>
                        </div>
                        <div style="padding: 0.75rem; background: rgba(255,255,255,0.05); border-radius: 0.75rem; height: fit-content;">
                            📈
                        </div>
                    </div>
                    <!-- <div style="color: #14F195; font-size: 0.875rem; font-weight: 600;">+12.3%</div> -->
                </div>
            </div>

            <div class="card" style="position: relative; overflow: hidden;">
                <div style="position: absolute; top: 0; right: 0; width: 128px; height: 128px; background: linear-gradient(135deg, var(--solana-purple), var(--solana-cyan)); opacity: 0.1; filter: blur(40px); border-radius: 50%;"></div>
                <div style="position: relative;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 1rem;">
                        <div>
                            <p style="color: rgba(255,255,255,0.6); font-size: 0.875rem; margin-bottom: 0.5rem;">Today Earnings</p>
                            <h3 style="font-size: 2rem; font-weight: 700;"><?= MemberHelper::user_daily_earnings(); ?> SOL</h3>
                        </div>
                        <div style="padding: 0.75rem; background: rgba(255,255,255,0.05); border-radius: 0.75rem; height: fit-content;">
                            ⚡
                        </div>
                    </div>
                    <div style="color: rgba(255,255,255,0.6); font-size: 0.875rem;">Last 24 hours</div>
                </div>
            </div>
        </div>

        <!-- Chart and Activity -->
        <div class="divblock" style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem; margin-bottom: 3rem;">
            <!-- Chart -->
            <div class="card">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                    <h2 style="font-size: 1.5rem; font-weight: 700;">Earnings Overview</h2>

                </div>

                <div style="height: 400px; position: relative;">
                    <?php
                    if (count($data['daily_growth']) >= 7) { ?>
                        <canvas id="earningsChart"></canvas>
                    <?php   } else { ?>
                        <img src="<?= base_url() ?>website/img/chart.jpg" style="width:100%;filter:blur(7px)" alt="">
                        <h5 class="text-center  fw-bold" style="    top: 50%;   left: 50%; width:90% !important;   transform: translate(-50%, -50%);  position: absolute;">This chart will be visible once sufficient data is available.</h5>
                    <?php } ?>
                </div>

                <!-- <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1.5rem; margin-top: 2rem; padding-top: 2rem; border-top: 1px solid rgba(255,255,255,0.1);">
                    <div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6); margin-bottom: 0.25rem;">Average Daily</div>
                        <div style="font-size: 1.25rem; font-weight: 700;">0.024 SOL</div>
                    </div>
                    <div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6); margin-bottom: 0.25rem;">Peak Day</div>
                        <div style="font-size: 1.25rem; font-weight: 700;">0.028 SOL</div>
                    </div>
                    <div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6); margin-bottom: 0.25rem;">Projected Monthly</div>
                        <div style="font-size: 1.25rem; font-weight: 700;" class="gradient-text">0.75 SOL</div>
                    </div>
                </div> -->
            </div>

            <!-- Recent Activity -->
            <div class="card card-2">
                <h2 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1.5rem;">Recent Activity</h2>

                <div style="max-height: 450px; overflow-y: auto;">
                    <?php $i = 1;
                    if (!empty($data['daily_growth'])) {


                        foreach ($data['daily_growth'] as $key => $row) {
                    ?>
                            <div style="display: flex; align-items: start; gap: 0.75rem; padding: 0.75rem; background: rgba(255,255,255,0.05); border-radius: 0.75rem; margin-bottom: 1rem; transition: background 0.3s;" onmouseover="this.style.background='rgba(255,255,255,0.1)'" onmouseout="this.style.background='rgba(255,255,255,0.05)'">
                                <div style="padding: 0.5rem; background: rgba(255,255,255,0.05); border-radius: 0.5rem; color: #14F195;">📈</div>
                                <div style="flex: 1; min-width: 0;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 0.25rem;">
                                        <span style="font-weight: 600; font-size: 0.875rem;">You have earned</span>
                                        <span style="font-size: 0.875rem; color: #14F195; font-weight: 600;">+<?= round($row['amount'], 3); ?> SOL</span>
                                    </div>
                                    <div style="font-size: 0.75rem; color: rgba(255,255,255,0.6);"><?= Helpers::date($row['created_at']); ?></div>
                                </div>
                            </div>
                        <?php $i++;
                        }
                    } else { ?>
                        <div>No activity yet — once you make your first deposit, daily earnings will begin showing up within 24 hours</div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <!-- APY Card -->
        <div class="card" style="text-align: center; background: linear-gradient(135deg, rgba(153, 69, 255, 0.1), rgba(0, 212, 255, 0.1)); border: 1px solid rgba(153, 69, 255, 0.3);">
            <div style="font-size: 3.5rem; font-weight: 700; margin-bottom: 0.5rem;" class="gradient-text">10%</div>
            <div style="color: rgba(255,255,255,0.8); margin-bottom: 1rem; font-size: 1.125rem;">Monthly earnings</div>
            <div style="color: rgba(255,255,255,0.6); font-size: 0.875rem;">Your estimated annual percentage yield based on current network rewards</div>
        </div>
    </div>
</div>

<?php
usort($data['daily_growth'], function ($a, $b) {
    return strtotime($a['created_at']) <=> strtotime($b['created_at']);
});
$labels = [];
$amounts = [];

foreach ($data['daily_growth'] as $row) {
    $labels[]  = date('d M Y', strtotime($row['created_at']));
    $amounts[] = $row['amount'];
}
?>

<script>
    // Initialize chart
    const ctx = document.getElementById('earningsChart').getContext('2d');
    const chart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?= json_encode($labels) ?>,
            datasets: [{
                label: 'Earnings (SOL)',
                data: <?= json_encode($amounts) ?>,
                borderColor: '#9945FF',
                backgroundColor: 'rgba(153, 69, 255, 0.1)',
                borderWidth: 3,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: false,
                    grid: {
                        color: 'rgba(255, 255, 255, 0.05)'
                    },
                    ticks: {
                        color: '#999'
                    }
                },
                x: {
                    grid: {
                        color: 'rgba(255, 255, 255, 0.05)'
                    },
                    ticks: {
                        color: '#999'
                    }
                }
            }
        }
    });

    function updateChart(range) {
        // This would update the chart with different data based on range
        showNotification('Chart updated to ' + range + ' view');
    }
</script>