<style>
    /* Modal Background */
    .custom-modal {
        display: none;
        /* JS se control hoga */
        position: fixed;
        z-index: 9999;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.85);
        backdrop-filter: blur(8px);
        overflow-y: auto;
    }

    /* Modal Content Box */
    .modal-content {
        background-color: #1a1a1a;
        margin: 10% auto;
        padding: 30px;
        border: 1px solid rgba(153, 69, 255, 0.4);
        width: 90%;
        max-width: 450px;
        border-radius: 1.5rem;
        color: white;
        box-shadow: 0 0 30px rgba(153, 69, 255, 0.3);
        position: relative;
        animation: modalFadeIn 0.3s ease-out;
    }

    /* Modal Open Animation */
    @keyframes modalFadeIn {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Form Input Styling */
    .modal-content .form-label {
        color: rgba(255, 255, 255, 0.7);
        font-size: 0.9rem;
        margin-bottom: 8px;
        display: block;
    }

    .modal-content .form-control-custom {
        width: 100%;
        background: rgba(0, 0, 0, 0.5);
        border: 1px solid rgba(153, 69, 255, 0.3);
        border-radius: 0.75rem;
        padding: 12px;
        color: #14F195;
        /* Solana Green for the code */
        font-size: 1.25rem;
        text-align: center;
        letter-spacing: 5px;
        outline: none;
        transition: 0.3s;
    }

    .modal-content .form-control-custom:focus {
        border-color: #14F195;
        box-shadow: 0 0 10px rgba(20, 241, 149, 0.2);
    }

    /* Close Button */
    .close-modal {
        position: absolute;
        right: 20px;
        top: 15px;
        font-size: 24px;
        cursor: pointer;
        color: rgba(255, 255, 255, 0.5);
        transition: 0.3s;
    }

    .close-modal:hover {
        color: white;
    }
</style>
<div style="padding-top: 140px; padding-bottom: 80px; min-height: 100vh; color: white;">
    <div class="container">
        <div class="row" style="max-width: 700px;margin:auto">
            <div class="text-center" style="margin-bottom: 30px;">
                <?php if ($this->session->flashdata()) {
                    echo Helpers::showFlash($this->session->flashdata("response"));
                } ?>
            </div>
            <div class="col-lg-6 m-auto">
                <div class="card" style="position: relative; overflow: hidden; border: 1px solid rgba(153, 69, 255, 0.3); padding: 2rem;">
                    <div style="position: relative; z-index: 1;">

                        <?php if ($data["status"] != 1) : ?>
                            <div class="text-center">
                                <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1.5rem;">Enable Google Authenticator</h3>

                                <?php if (isset($data["qrCodeUrl"])) : ?>
                                    <div style="background: white; padding: 1rem; border-radius: 1rem; display: inline-block; margin-bottom: 1.5rem;">
                                        <img src="<?= $data["qrCodeUrl"] ?>" alt="QR Code" style="width: 200px; height: 200px;">
                                    </div>

                                    <div class="glass" style="padding: 1rem; border-radius: 0.75rem; margin-bottom: 1.5rem; border: 1px solid rgba(255,255,255,0.1);">
                                        <p style="font-size: 0.875rem; color: rgba(255,255,255,0.6); margin-bottom: 0.5rem;">Secret Key</p>
                                        <code style="color: var(--solana-cyan); font-size: 1.1rem; letter-spacing: 1px; font-weight: 700;"><?= $data["secret"] ?></code>
                                    </div>
                                <?php endif; ?>
                                <p style="font-size: 0.875rem; color: rgba(255,255,255,0.6); margin-bottom: 1.5rem;">
                                    Scan the QR code above with your Google Authenticator app, then click to Verify.
                                </p>

                                <button type="button" onclick="open2faModal()" class="btn btn-primary" style="width: 100%; max-width: unset!important;">
                                    Verify
                                </button>
                            </div>

                        <?php else : ?>
                            <div class="text-center">
                                <div style="font-size: 3rem; margin-bottom: 1rem;">🛡️</div>
                                <h3 style="font-size: 1.5rem; font-weight: 700; margin-bottom: 1rem;">2FA is Active</h3>
                                <form method="post" action="<?= base_url(); ?>disable_2fa">
                                    <input type="hidden" name="code" value="1">
                                    <button type="submit" class="btn btn-secondary" style="width: 100%; max-width: unset!important; color: #ff4d4d;">
                                        Deactivate 2FA
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="twoFactorModal" class="custom-modal">
    <div class="modal-content">
        <span class="close-modal" onclick="close2faModal()">&times;</span>

        <h3 style="font-weight: 700; margin-bottom: 10px;">Verify 2FA Code</h3>
        <p style="font-size: 0.85rem; color: rgba(255,255,255,0.6); margin-bottom: 25px;">
            Enter the 6-digit security code from your Google Authenticator app.
        </p>

        <form method="post" action="<?= base_url() ?>handle_2fa">
            <div class="form-group">
                <label class="form-label">Enter 6-Digit Code</label>
                <input type="text" name="code" class="form-control-custom" placeholder="000000" maxlength="6" required>
            </div>

            <input type="hidden" name="secret" value="<?= $data["secret"] ?>">

            <div style="margin-top: 25px;">
                <input type="submit" class="btn btn-primary w-100" value="Activate 2FA" style="width: 100%; max-width: unset!important;">
            </div>
        </form>
    </div>
</div>

<script>
    // Modal open function
    function open2faModal() {
        document.getElementById('twoFactorModal').style.display = 'block';
        // Prevent body scroll when modal is open
        document.body.style.overflow = 'hidden';
    }

    // Modal close function
    function close2faModal() {
        document.getElementById('twoFactorModal').style.display = 'none';
        // Restore body scroll
        document.body.style.overflow = 'auto';
    }

    // Close modal if user clicks outside of the box
    window.onclick = function(event) {
        let modal = document.getElementById('twoFactorModal');
        if (event.target == modal) {
            close2faModal();
        }
    }
</script>