<?php

/**
 * SOLSTAKER LIVE PRICE FEED
 * Fetches data from CoinGecko API using cURL
 */

// 1. Setup the API URL
$url = "https://api.coingecko.com/api/v3/simple/price?ids=bitcoin,ethereum,bnb,dogecoin,solana,tether&vs_currencies=usd";

// 2. Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

// 3. Set a User-Agent to prevent "403 Forbidden" errors
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) Chrome/91.0.4472.124 Safari/537.36');

// 4. Execute and close
$response = curl_exec($ch);
curl_close($ch);

// 5. Decode the data
$data = json_decode($response, true);
// echo '<pre>';
// print_r($data);
// exit;
// 6. Extract prices with fallbacks (default to 0 if API fails)
$sol_price  = $data['solana']['usd'] ?? 0;
$btc_price  = $data['bitcoin']['usd'] ?? 0;
$eth_price  = $data['ethereum']['usd'] ?? 0;
$bnb_price  = $data['binancecoin']['usd'] ?? 0;
$dog_price  = $data['dogecoin']['usd'] ?? 0;
$usdt_price = $data['tether']['usd'] ?? 0;
?>
<!-- Hero Section -->
<section class="hero">
    <div class="hero-bg">
        <div class="bg-gradient-1"></div>
        <div class="bg-gradient-2"></div>
        <div class="bg-gradient-3"></div>
    </div>

    <div class="container">
        <div class="hero-content">
            <div class="hero-badge" style="margin-top:70px">
                ✨ Trusted by thousands of SOL stakers
            </div>

            <h1>
                Welcome to SolStaker <br>
                <span class="gradient-text">Earn Daily Rewards.</span>
            </h1>

            <p class="hero-subtitle">
                Simple. Secure. Fully automated staking powered by Solana.<br>
                Start earning up to <span class="gradient-text" style="font-weight: 600;">10% </span> Monthly.
            </p>
            <!-- <p class="mobile_none" style="    margin-bottom: 20px;max-width: 800px">At <strong>SolStaker</strong>SolStaker, we are pioneering the seamless integration of <strong>cutting-edge artificial intelligence</strong> with the power of the <strong>Solana blockchain</strong>, creating an <strong>unmatched staking experience</strong>. By combining Solana’s high-speed network with <strong>AI-driven staking strategies</strong>, we optimize returns beyond traditional staking platforms—offering <strong>efficiency, security, and profitability at scale</strong>
            </p> -->
            <div class="hero-cta">
                <a href="<?= base_url() ?>register" class="btn btn-primary">Start Earning →</a>
                <!-- <a href="about.html" class="btn btn-secondary">How It Works</a> -->
            </div>
            <h4 class="gradient-text" style="margin-top:40px;">Solana’s Top Growing Ai Staking Platfrom</h4>
            <div class="hero-stats" style="display: flex;justify-content:center;align-items:center;margin-top:15px;">
                <div class="stat-card">
                    <div class="stat-valu">1</div>
                    <div class="stat-label">SOL</div>
                </div>
                <div style="font-size: 30px;">=</div>
                <div class="stat-card">
                    <div class="stat-valu"><?php echo $sol_price; ?></div>
                    <div class="stat-label">USD</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Benefits Section -->
<a name="why"></a>
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2>Why Choose <span class="gradient-text">SolStaker</span></h2>
            <p>The simplest and most rewarding way to stake your SOL</p>
        </div>

        <div class="grid grid-4">
            <div class="card">
                <div class="card-icon">◈</div>
                <h3>Daily Rewards</h3>
                <p>Earn rewards every day, automatically credited to your account. Watch your SOL grow with compound interest.</p>
            </div>

            <div class="card">
                <div class="card-icon">⟠</div>
                <h3>No Lockups</h3>
                <p>Your SOL is never locked. Withdraw anytime without penalties or waiting periods. Complete freedom.</p>
            </div>

            <div class="card">
                <div class="card-icon">⚡</div>
                <h3>Withdraw Anytime</h3>
                <p>Need your funds? Withdraw instantly. No complicated unstaking process or delays. Your SOL, your control.</p>
            </div>

            <div class="card">
                <div class="card-icon">◉</div>
                <h3>Industry-Leading Security</h3>
                <p>Bank-grade encryption, multi-signature wallets, and regular security audits. Your assets are protected.</p>
            </div>
        </div>
    </div>
</section>

<section>
    <div class="container">
        <div class="section-header" style="margin-bottom: 20px;">
            <h3><span class="gradient-text">SolStaker</span>: The Future of Staking and AI-Powered Growth </h3>
            <!-- <p>Five simple steps to start earning passive income</p> -->
        </div>
        <div class="card mb-3">
            <div style="display: flex; gap: 1.5rem; align-items: start;">
                <div>
                    <p>At SolStaker, we are pioneering the seamless integration of sophisticated artificial intelligence with the powerful Solana blockchain, creating an unmatched staking experience that offers significantly optimized returns. With Solana's exceptional throughput and our state-of-the-art AI trading algorithms, SolStaker provides a unique blend of speed, security, and efficiency.</p>

                </div>
            </div>
        </div>
    </div>
</section>
<!-- How It Works Section -->
<a name="how"></a>
<section class="section" style="background: linear-gradient(to bottom, transparent, rgba(255,255,255,0.02));">
    <div class="container">
        <div class="section-header">
            <h2>How <span class="gradient-text">SolStaker</span> Works</h2>
            <!-- <p>Five simple steps to start earning passive income</p> -->
        </div>

        <div style="max-width: 900px; margin: 0 auto;">
            <div class="card mb-3">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>The Next Generation of Staking</h3>
                        <p>SolStaker harnesses the capabilities of <strong>Solana’s lightning-fast blockchain—</strong>processing up to <strong>65,000 transactions per second</strong>—alongside our advanced AI staking system. This combination allows us to <strong>dynamically optimize staking rewards</strong> and ensure <strong>maximum profitability</strong> for our users.</p>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>Unmatched Returns – Up to 10% Monthly</h3>
                        <p>While traditional staking platforms offer modest annual yields, SolStaker redefines expectations with up to 10% monthly ROI. Our AI-driven strategies maximize staking efficiency, capturing opportunities in real time to generate superior returns</p>
                        <p style="font-size:15px;">Note: As more users join, rewards will gradually decrease to ensure long-term sustainability. Early stakers get the most.</p>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>Security You Can Trust</h3>
                        <p>Your assets are protected by the most advanced security measures, including:<br>
                            - Bank-grade encryption to safeguard transactions<br>
                            - Multi-factor authentication (MFA) for enhanced account security<br>
                            - Continuous real-time monitoring to prevent threats</p>
                        <p style="font-size:15px;">We prioritize full transparency, ensuring you have complete visibility into your funds and rewards.</p>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>Empowering Our Clients Through Education and Transparency</h3>
                        <p>We believe in empowering our users with the knowledge to make informed investment decisions. SolStaker provides detailed insights into the operational strategies of both the AI trading system and the underlying blockchain mechanics. Our platform ensures that all participants understand the nuances of their investments and the market forces at play.</p>
                    </div>
                </div>
            </div>

            <div class="card mb-3">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>Liquidity & Full Control – No Lock-Ups</h3>
                        <p>Unlike many staking platforms that impose restrictions, SolStaker offers full liquidity and flexibility.<br>
                            ✔ Withdraw anytime—no penalties, no lock-ups<br>
                            ✔ Adjust your staking amount freely<br>
                            ✔ Stay in control of your digital assets at all times</p>
                    </div>
                </div>
            </div>
            <div class="card">
                <div style="display: flex; gap: 1.5rem; align-items: start;">
                    <div style="width: 48px; height: 48px; border-radius: 0.75rem; background: linear-gradient(135deg, var(--solana-purple) 0%, var(--solana-blue) 100%); display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 1.25rem; flex-shrink: 0;"></div>
                    <div>
                        <h3>Join the Future of Staking Today</h3>
                        <p>The staking revolution is here. SolStaker is designed for those who seek more than just passive income—it’s built for those who want to maximize their SOL’s potential in a secure, intelligent, and high-performance environment.

                            Stake today. Earn smarter. Secure your future.</p>
                        <div class="hero-cta" style="margin-top: 20px;justify-content:flex-start">
                            <a href="<?= base_url() ?>register" class="btn btn-primary">Join Now →</a>
                            <!-- <a href="about.html" class="btn btn-secondary">How It Works</a> -->
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2>Trusted by <span class="gradient-text">Thousands</span></h2>
            <p>Join our community of satisfied stakers</p>
        </div>

        <div class="grid grid-3">
            <div class="card">
                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>
                <p style="margin-bottom: 1.5rem;">"SolStaker made staking incredibly simple. I earn daily rewards without any technical knowledge. The interface is beautiful and everything just works."</p>
                <div style="display: flex; align-items: center; gap: 0.75rem;">
                    <div style="font-size: 2rem;">👩‍💼</div>
                    <div>
                        <div style="font-weight: 600;">Sarah Chen</div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">Crypto Investor</div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>
                <p style="margin-bottom: 1.5rem;">"Best staking platform I've used. No lockups, instant withdrawals, and competitive APY. The dashboard shows everything I need at a glance."</p>
                <div style="display: flex; align-items: center; gap: 0.75rem;">
                    <div style="font-size: 2rem;">👨‍💻</div>
                    <div>
                        <div style="font-weight: 600;">Marcus Rodriguez</div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">DeFi Enthusiast</div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div style="margin-bottom: 1rem; color: var(--solana-cyan);">★★★★★</div>
                <p style="margin-bottom: 1.5rem;">"I've been staking with SolStaker for 6 months. Rewards are consistent, support is excellent, and I love the transparency. Highly recommended!"</p>
                <div style="display: flex; align-items: center; gap: 0.75rem;">
                    <div style="font-size: 2rem;">👩‍🔬</div>
                    <div>
                        <div style="font-weight: 600;">Emily Watson</div>
                        <div style="font-size: 0.875rem; color: rgba(255,255,255,0.6);">Long-term Holder</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<a name="faq"></a>
<section class="section">
    <div class="container">
        <div class="section-header">
            <h2>Frequently Asked <span class="gradient-text">Questions</span></h2>
            <p>Everything you need to know about staking with SolStaker</p>
        </div>

        <div class="accordion">
            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>What is SolStaker?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        SolStaker is a high-yield staking platform built on the Solana blockchain. It allows users to stake their SOL tokens and earn passive rewards while contributing to the network’s security and efficiency.
                    </div>
                </div>
            </div>

            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>What is staking?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        Staking is a process used in certain types of cryptocurrencies that operate on a proof-of-stake (PoS) model. Instead of mining, which is used in proof-of-work systems like Bitcoin, proof-of-stake systems allow cryptocurrency holders to "stake" their coins in a network wallet to support block creation and transaction verification. In return, stakers earn rewards, typically in the form of additional coins or transaction fees, proportional to the amount of their holdings that they stake.<br>

                        This method is considered more energy-efficient than mining and helps increase the security and performance of the blockchain by ensuring that participants have a vested interest in the proper maintenance of the network. SolStaker. allows users to participate in this process, earning rewards by holding and staking their SOL.
                    </div>
                </div>
            </div>

            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>Is SolStaker safe?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        SolStaker boasts one of the world's most sophisticated security technology and maintenance team, and is constantly upgrading our security systems to ensure the safety of user assets and accounts.
                    </div>
                </div>
            </div>

            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>Can I start staking with just 10 SOL?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        SolStaker allows users to improve their practical experience through a variety of staking and financial products for as low as 10 SOL.
                    </div>
                </div>
            </div>

            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span> When can I withdraw my revenue?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        SolStaker has no limit for cash outs. You can withdraw your crypto anytime you want.
                    </div>
                </div>
            </div>

            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>How do I start staking?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        • Register an Account – Sign up on SolStaker and verify your email.<br>
                        • Deposit SOL – Send minimum of 10 SOL to your deposit address found on the deposit page.<br>
                        • Staking Starts Automatically – No extra steps needed, rewards begin accumulating.

                    </div>
                </div>
            </div>
            <div class="accordion-item">
                <button class="accordion-header" onclick="toggleAccordion(this)">
                    <span>When does staking start?</span>
                    <span class="accordion-icon">▼</span>
                </button>
                <div class="accordion-content">
                    <div class="accordion-body">
                        • Staking starts automatically as soon as your SOL deposit is confirmed.<br>
                        • No manual setup is required—your funds begin earning rewards immediately.<br>
                        • Daily rewards will appear in your account starting the next day after deposit.<br>
                        • You can withdraw anytime with no lock-up periods.
                    </div>
                </div>
            </div>
        </div>

        <!-- <div class="text-center mt-4">
                <p style="color: rgba(255,255,255,0.6); margin-bottom: 1.5rem;">Still have questions?</p>
                <a href="faq.html" class="btn btn-secondary">View All FAQs</a>
            </div> -->
    </div>
</section>

<!-- Footer -->
<footer class="footer">
    <div class="container">
        <div class="footer-grid">
            <div class="footer-brand">
                <a href="<?= base_url() ?>" class="logo">
                    <img src="<?= base_url() ?>website/img/logo/logo.png" width="40" alt="logo">
                    <span class="logo-text">SolStaker</span>
                </a>
                <p>Stake SOL automatically and earn daily rewards. Simple, secure, and fully automated staking powered by Solana.</p>
            </div>

            <!-- <div class="footer-section">
                    <h3>Product</h3>
                    <ul class="footer-links">
                        <li><a href="dashboard.html">Dashboard</a></li>
                        <li><a href="deposit.html">Deposit</a></li>
                        <li><a href="withdraw.html">Withdraw</a></li>
                        <li><a href="about.html">How It Works</a></li>
                    </ul>
                </div> -->

            <div class="footer-section">
                <h3>Quick Links</h3>
                <ul class="footer-links">

                    <li><a href="<?= base_url() ?>login">Sign In</a></li>
                    <li><a href="<?= base_url() ?>register">Sign Up</a></li>
                    <li><a href="<?= base_url() ?>">Home</a></li>
                </ul>
            </div>

            <!-- <div class="footer-section">
                <h3>Company</h3>
                <ul class="footer-links">
                    <li><a href="#">Terms of Use</a></li>
                    <li><a href="#">Privacy Policy</a></li>
                    <li><a href="#">Law Enforcement Request Guidelines</a></li>

                </ul>
            </div> -->
        </div>
        <div class="footer-bottom" style="border-top: none; padding-top: 0;">
            <p>© 2025 SolStaker. All rights reserved.</p>
            <p>Built on <span class="gradient-text" style="font-weight: 600;">Solana</span></p>
        </div>
    </div>
</footer>

<script src="<?= base_url() ?>website/js/main.js"></script>


</body>

</html>