<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SolStaker</title>
    <meta name="description" content="SolStaker">
    <link rel="shortcut icon" type="image/x-icon" href="<?= base_url(); ?>website/img/favicon.png">
    <link rel="stylesheet" href="<?= base_url() ?>website/css/style.css">
    <style>
        .footer-brand {
            grid-column: unset !important;
        }

        .dropdown-menu {
            min-width: 200px !important;
        }

        .dropdown-menu li a {
            display: block;
            padding: 12px 10px;
            color: rgba(255, 255, 255, 0.7) !important;
            text-decoration: none;
            font-size: 0.9rem;
            font-weight: 500;
            letter-spacing: 0.5px;
            border-radius: 8px;
            transition: all 0.25s ease;
            border-left: 3px solid transparent;
            /* Hidden border for hover effect */
        }

        /* Hover Effect */
        .dropdown-menu li a:hover {
            background: rgba(153, 69, 255, 0.1);
            /* Very light purple tint */
            color: #14F195 !important;
            /* Solana Green Text */
            border-left: 3px solid #9945FF;
            /* Purple accent line shows up */
            padding-left: 25px;
            /* Subtle push to the right */
        }

        /* Ensure no default bullets from any parent theme */
        .dropdown-menu li::before {
            content: none !important;
        }

        /* Entrance Animation */
        @keyframes fadeInTop {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* --- Desktop Settings --- */
        @media (min-width: 769px) {
            .mobile-only {
                display: none !important;
                /* Mobile links desktop par nahi dikhenge */
            }

            .custom-dropdown {
                position: relative;
                display: inline-block;
            }

            .dropdown-menu {
                display: none;
                position: absolute;
                top: 100%;
                right: 0;
                background: rgba(10, 10, 10, 0.95);
                border: 1px solid rgba(153, 69, 255, 0.4);
                min-width: 180px;
                border-radius: 12px;
                padding: 10px 0;
                z-index: 100;
            }

            .custom-dropdown:hover .dropdown-menu {
                display: block;
            }
        }

        /* --- Mobile Settings --- */
        @media (max-width: 768px) {
            .desktop-only {
                display: none !important;
                /* Settings Dropdown mobile par gayab */
            }

            .mobile-only {
                display: block !important;
                /* Single links mobile par show honge */
            }

            /* Mobile menu list styling */
            .nav-links li {
                width: 100%;
                border-bottom: 1px solid rgba(255, 255, 255, 0.05);
            }

            .nav-links li a {
                padding: 15px 20px;
                display: block;
            }

            /* Side Drawer */
            .mobile-drawer {
                position: fixed !important;
                top: 0 !important;
                height: auto !important;
                width: 280px !important;
                background: #0d0d0d !important;
                border-left: 1px solid rgba(153, 69, 255, 0.3) !important;
                padding: 0px 20px !important;
                transition: 0.4s cubic-bezier(0.4, 0, 0.2, 1) !important;
                display: flex !important;
                flex-direction: column !important;
                align-items: baseline;
            }

            .mobile-drawer {
                right: 0 !important;
            }

            /* Drawer Header */
            .drawer-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 40px;
            }

            .close-btn {
                background: none;
                border: none;
                color: white;
                font-size: 2rem;
                cursor: pointer;
            }

            /* Link List */
            .nav-links {
                list-style: none;
                padding: 0;
            }

            .nav-links li {
                margin-bottom: 10px;
            }

            .nav-links li a {
                color: rgba(255, 255, 255, 0.8);
                text-decoration: none;
                font-size: 1.1rem;
                display: block;
                padding: 0px 0px !important;
                border-radius: 10px;
                transition: 0.3s;
            }

            .nav-links {
                gap: 1rem !important;
            }

            .nav-links li a:hover {
                background: rgba(153, 69, 255, 0.1);
                color: #14F195;
            }

            .drawer-header {
                display: flex !important;
                justify-content: space-between;
                align-items: center;
                width: 100%;
                padding: 20px 0px 0px;
            }

            .close-btn {
                background: none;
                border: none;
                color: white;
                font-size: 2rem;
                cursor: pointer;
            }

            .nav-links.active {
                left: unset !important;
            }

            #mobile_nav {
                opacity: 0 !important;
                visibility: hidden;
                /* Taaki hidden hone par links par click na ho sake */
                pointer-events: none;
                transition: opacity 0.4s ease;
            }

            /* Jab active class add hogi tab menu dikhega */
            #mobile_nav.active {
                opacity: 1 !important;
                visibility: visible;
                pointer-events: auto;
            }
        }

        .drawer-header {
            display: none;
        }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar" id="navbar">
        <div class="container">
            <div class="navbar-content">
                <a href="<?= base_url() ?>" class="logo">
                    <img src="<?= base_url() ?>website/img/logo/logo.png" width="40" alt="logo">
                    <span class="logo-text">SolStaker</span>
                </a>

                <ul class="nav-links mobile-drawer" id="mobile_nav">
                    <div class="drawer-header">
                        <span class="logo-text">SolStaker</span>
                        <button class="close-btn" onclick="toggleMobileMenu()">&times;</button>
                    </div>
                    <li class="mt-100"><a href="<?= base_url() ?>">Home</a></li>

                    <?php if ($this->session->userdata('user')) { ?>
                        <li><a href="<?= base_url() ?>main_wallet">Main Wallet</a></li>
                        <li><a href="<?= base_url() ?>deposit">Deposit</a></li>
                        <li><a href="<?= base_url() ?>withdrawal">Withdrawal</a></li>

                        <li class="desktop-only custom-dropdown">
                            <a href="javascript:void(0)">Settings ▼</a>
                            <ul class="dropdown-menu" style="padding: 0px 10px;">
                                <li style="list-style: none !important"><a href="<?= base_url() ?>profile">Profile</a></li>
                                <li style="list-style: none !important"><a href="<?= base_url() ?>two_factor">2FA Security</a></li>
                                <li style="list-style: none !important"><a href="<?= base_url() ?>change_password">Change Password</a></li>
                            </ul>
                        </li>

                        <li class="mobile-only"><a href="<?= base_url() ?>profile">Profile</a></li>
                        <li class="mobile-only"><a href="<?= base_url() ?>two_factor">2FA Security</a></li>
                        <li class="mobile-only"><a href="<?= base_url() ?>change_password">Change Password</a></li>

                        <li><a href="<?= base_url() ?>logout">Logout</a></li>

                    <?php } else { ?>
                        <li><a href="<?= base_url() ?>login">Sign In</a></li>
                        <a href="<?= base_url() ?>register" class="btnm1 btn btn-primary">Start Earning</a>
                    <?php } ?>
                </ul>

                <?php if (!$this->session->userdata('user')) { ?>

                    <a href="<?= base_url() ?>register" class="btnm2 btn btn-primary">Start Earning</a>

                <?php } ?>
                <button class="mobile-menu-btn" onclick="toggleMobileMenu()">☰</button>
            </div>
        </div>
    </nav>