// Navbar scroll effect
window.addEventListener('scroll', function () {
	const navbar = document.getElementById('navbar');
	if (window.scrollY > 20) {
		navbar.classList.add('scrolled');
	} else {
		navbar.classList.remove('scrolled');
	}
});

// Accordion functionality
function toggleAccordion(button) {
	const item = button.parentElement;
	const wasActive = item.classList.contains('active');

	// Close all accordions
	document.querySelectorAll('.accordion-item').forEach(function (accordionItem) {
		accordionItem.classList.remove('active');
	});

	// Open clicked accordion if it wasn't active
	if (!wasActive) {
		item.classList.add('active');
	}
}

// Mobile menu toggle
// function toggleMobileMenu() {
// 	alert('Mobile menu would open here. For this demo, please use the desktop view or navigate directly to pages.');
// }
function toggleMobileMenu() {
	const menu = document.querySelector('.nav-links');
	menu.classList.toggle('active');
}
document.querySelectorAll('.nav-links a').forEach(link => {
	link.addEventListener('click', () => {
		document.querySelector('.nav-links').classList.remove('active');
	});
});

// Copy to clipboard function
function copyToClipboard(text, button) {
	navigator.clipboard.writeText(text).then(function () {
		const originalText = button.innerHTML;
		button.innerHTML = '✔ Copied';
		button.style.color = '#14F195';

		setTimeout(function () {
			button.innerHTML = originalText;
			button.style.color = '';
		}, 2000);
	}).catch(function (err) {
		console.error('Failed to copy:', err);
	});
}

// Format SOL amount
function formatSOL(amount, decimals = 2) {
	return parseFloat(amount).toFixed(decimals);
}

// Format number with commas
function formatNumber(num) {
	return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

// Animate numbers on scroll
function animateValue(element, start, end, duration) {
	const range = end - start;
	const increment = range / (duration / 16);
	let current = start;

	const timer = setInterval(function () {
		current += increment;
		if ((increment > 0 && current >= end) || (increment < 0 && current <= end)) {
			current = end;
			clearInterval(timer);
		}
		element.textContent = formatNumber(Math.floor(current));
	}, 16);
}

// Initialize animations when page loads
window.addEventListener('load', function () {
	// Animate stat cards if they exist
	const statCards = document.querySelectorAll('.stat-value');
	statCards.forEach(function (card) {
		const value = card.textContent;
		const numericValue = parseInt(value.replace(/[^0-9]/g, ''));
		if (numericValue && !isNaN(numericValue)) {
			card.textContent = '0';
			setTimeout(function () {
				animateValue(card, 0, numericValue, 2000);
			}, 300);
		}
	});
});

// Form validation helper
function validateSolanaAddress(address) {
	const solanaAddressRegex = /^[1-9A-HJ-NP-Za-km-z]{32,44}$/;
	return solanaAddressRegex.test(address);
}

// Show notification
function showNotification(message, type = 'success') {
	const notification = document.createElement('div');
	notification.style.cssText = `
        position: fixed;
        top: 100px;
        right: 20px;
        padding: 1rem 1.5rem;
        background: ${type === 'success' ? 'rgba(20, 241, 149, 0.1)' : 'rgba(255, 69, 69, 0.1)'};
        border: 1px solid ${type === 'success' ? 'rgba(20, 241, 149, 0.3)' : 'rgba(255, 69, 69, 0.3)'};
        border-radius: 0.75rem;
        color: ${type === 'success' ? '#14F195' : '#ff4545'};
        font-weight: 600;
        z-index: 10000;
        animation: slideIn 0.3s ease;
    `;
	notification.textContent = message;
	document.body.appendChild(notification);

	setTimeout(function () {
		notification.style.animation = 'slideOut 0.3s ease';
		setTimeout(function () {
			document.body.removeChild(notification);
		}, 300);
	}, 3000);
}

// Add CSS animations for notifications
const style = document.createElement('style');
style.textContent = `
    @keyframes slideIn {
        from {
            transform: translateX(400px);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }

    @keyframes slideOut {
        from {
            transform: translateX(0);
            opacity: 1;
        }
        to {
            transform: translateX(400px);
            opacity: 0;
        }
    }
`;
document.head.appendChild(style);