<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SolStaker</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #050505;
            /* Deepest black */
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            color: #ffffff;
        }

        .wrapper {
            width: 100%;
            background-color: #050505;
            padding: 60px 0;
            /* Creates a subtle purple/blue ambient glow in the background */
            background-image: radial-gradient(circle at 50% 0%, #261645 0%, #050505 50%);
        }

        .main-card {
            margin: 0 auto;
            width: 100%;
            max-width: 675px;
            background-color: #111111;
            border-radius: 28px;
            border: 1px solid #222222;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0, 0, 0, 0.5);
        }

        .header-gradient {
            height: 6px;
            background: linear-gradient(90deg, #a855f7, #3b82f6, #10b981);
        }

        .content {
            padding: 50px 40px;
        }

        .logo-box {
            text-align: center;
            margin-bottom: 40px;
        }

        h1 {
            font-size: 32px;
            font-weight: 800;
            margin-bottom: 24px;
            letter-spacing: -1px;
            text-align: center;
        }

        .status-badge {
            display: inline-block;
            padding: 6px 16px;
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
            border-radius: 100px;
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 20px;
        }

        p {
            font-size: 16px;
            line-height: 1.8;
            color: #a0a0a0;
            margin-bottom: 20px;
        }

        .action-area {
            text-align: center;
            padding: 30px 0;
        }

        .btn-primary {
            display: inline-block;
            background: #ffffff;
            color: #000000 !important;
            text-decoration: none;
            padding: 16px 40px;
            border-radius: 14px;
            font-weight: 700;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .footer {
            text-align: center;
            padding: 15px 00px;
            color: #444444;
            font-size: 13px;
        }

        .divider {
            height: 1px;
            background: #222222;
            margin: 30px 0;
        }

        /* Responsive */
        @media screen and (max-width: 600px) {
            .main-card {
                width: 92% !important;
                border-radius: 20px;
            }

            .content {
                padding: 40px 25px;
            }
        }
    </style>
    <style>
        .logo-text {
            font-size: 1.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            justify-content: center;
            text-decoration: none;
            transition: transform 0.3s ease;
            margin-bottom: 50px;
        }

        .logo-icon {
            width: 40px;
            height: 40px;
            border-radius: 0.5rem;
            background: linear-gradient(135deg, #9945FF 0%, #14F195 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }
    </style>
</head>

<body>
    <div class="wrapper">
        <table class="main-card" cellpadding="0" cellspacing="0">
            <tr>
                <td class="header-gradient"></td>
            </tr>
            <tr>
                <td class="content">
                    <a href="<?= base_url() ?>" class="logo">
                        <div class="logo-icon">
                            <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5.5 20.5L10 16L5.5 11.5L7 10L13 16L7 22L5.5 20.5Z" fill="url(#gradient1)" />
                                <path d="M14 11H26V13H14V11Z" fill="url(#gradient2)" />
                                <path d="M14 19H26V21H14V19Z" fill="url(#gradient3)" />
                                <defs>
                                    <linearGradient id="gradient1" x1="5.5" y1="10" x2="13" y2="22" gradientUnits="userSpaceOnUse">
                                        <stop stopColor="#9945FF" />
                                        <stop offset="1" stopColor="#14F195" />
                                    </linearGradient>
                                    <linearGradient id="gradient2" x1="14" y1="11" x2="26" y2="13" gradientUnits="userSpaceOnUse">
                                        <stop stopColor="#9945FF" />
                                        <stop offset="1" stopColor="#00D4FF" />
                                    </linearGradient>
                                    <linearGradient id="gradient3" x1="14" y1="19" x2="26" y2="21" gradientUnits="userSpaceOnUse">
                                        <stop stopColor="#14F195" />
                                        <stop offset="1" stopColor="#00D4FF" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <span class="logo-text">SolStaker</span>
                    </a>

                    <div style="text-align: center;margin-bottom: 40px;">
                        <h1>Welcome To SolStaker</h1>
                    </div>

                    <p>Dear Admin,
                    </p>

                    <p style="margin-top:15px"><?= $user['username']; ?> has requested

                        <?= $amount; ?> for withdrawal.</p>

                    <p style="margin-top: 20px;">Kind Regards</p>
                    <p style="margin-top:15px">Team SolStaker</p>

                    <div class="divider"></div>
                    <div class="footer">
                        <p style="margin:0px; opacity: 0.5;">&copy; 2026 solstaker. All Rights Reserved</p>
                    </div>

                </td>
            </tr>
        </table>


    </div>
</body>

</html>